/*************************************************************************
 * This file is adopted from TextDiagramItem.cpp and TextDiagramItem.h    
 *
 * Project created in conformity with the requirements for the Degree of
 * Master of Engineering in Software Engineering, Computing and Software
 * Department, McMaster University 2004 - 2008
 *
 * Author:	Xiao Ma
 * Supervisor: Dr. Ryan Leduc
*************************************************************************/

/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the example classes of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include <QtGui>

#include "GedDesLabel.h"
#include "GedDesScene.h"
#include "GedDesTrans.h"
#include "GedDesState.h"
#include "CommonDefinitions.h"

// for debug
// #include <iostream>

namespace DESpot
{
GedDesLabel::GedDesLabel(QGraphicsItem *parent, QGraphicsScene *scene)
    : QGraphicsTextItem(parent, scene)
{
    setFlag(QGraphicsItem::ItemIsMovable);
    setFlag(QGraphicsItem::ItemIsSelectable);
    setTextInteractionFlags(Qt::NoTextInteraction);

    // this will prevent being rotating or scaled by others
    //setFlag(QGraphicsItem::ItemIgnoresTransformations,true);

    //set position to default value so can tell when position has been
    //assigned 
    QPointF tmpPoint(defaultGedItemValue, defaultGedItemValue);
    setPos(tmpPoint);

    // next needed for changes made to qt 4.6 and greater
#ifdef  __QT_Vers_gteq_4_6__
    setFlag(QGraphicsItem::ItemSendsGeometryChanges);
#endif
}

QVariant GedDesLabel::itemChange(GraphicsItemChange change,
                     const QVariant &value)
{
  if (change == QGraphicsItem::ItemSelectedChange) {
    emit selectedChange(this);

    // this part added to allow movement of entire DES at once
    // This prevents a selfloop transition to be moved (whic moves
    // its label as well)  and then have the a second movement applied
    // toi label itself.
    if (value.toBool()) {
      QGraphicsItem *parent =  parentItem();

      // check to make sure that parent is not set to zero
      if (parent) {
	if (parent->type() == GedDesTrans::Type) {
	  GedDesTrans *pTrans=qgraphicsitem_cast<GedDesTrans *>(parent);
	  if ((pTrans->isSelfLoop()) && (pTrans->isSelected())) {
	    setFlag(QGraphicsItem::ItemIsMovable,false);
	  }
	}
      }
    } else  {
      // ensures when only label se;lected, it can be repositioned
      setFlag(QGraphicsItem::ItemIsMovable,true);
    }
  }

    return value;
}

void GedDesLabel::focusOutEvent(QFocusEvent *event)
{
    setTextInteractionFlags(Qt::NoTextInteraction);
    emit lostFocus(this);
    QGraphicsTextItem::focusOutEvent(event);
}

void GedDesLabel::mousePressEvent(QGraphicsSceneMouseEvent *event)
{
    scene()->clearSelection();
    QGraphicsTextItem::mousePressEvent(event);
    setSelected(true);
	//QGraphicsItem *item = qobject_cast<QGraphicsItem *>(parentItem());
	//parentItem()->setSelected(true);
}

void GedDesLabel::mouseMoveEvent(QGraphicsSceneMouseEvent *event)
{
    if (textInteractionFlags() & Qt::TextEditable) {
        QGraphicsTextItem::mouseMoveEvent(event);
    } else
        QGraphicsItem::mouseMoveEvent(event);
}

}
