/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include "ProjIntegrityAlgo.h"

namespace DESpot
{
	class DesHierProject;

	class HierProjIntegrityAlgo: public ProjIntegrityAlgo
	{
		public:
			HierProjIntegrityAlgo(bool runIncremental = true);
			HierProjIntegrityAlgo(DesHierProject* project, bool runIncremental = true);
			virtual ~HierProjIntegrityAlgo(void);

		//Verification methods: return true if the verification was succesfull and they
		//output warnings and errors in m_warnList and m_errList. Note a verification is
		//successful even if there are warnings
		//protected:
			//Overridable called from the "run" method of the base implementation of the algorithm
			virtual bool verifyIntegrity();

			virtual bool verifyHighLevelSubsystem();
			
			virtual bool verifyInterfaces();

			virtual bool verifyLowLevelSubsystems();

			bool verifySubsystem(const DesSubsystem& subsys);
			bool verifyInterface(const DesInterface& interf);

		protected:
			DesHierProject* hierProject();

		private:
			static const std::wstring cHierProjIntegAlgoDesc;

			//Warnings
			static const std::wstring cInvalidSubsysNameWarn;
			static const std::wstring cInvalidInterfNameWarn;

			//Errors
			static const std::wstring cSubsysEmptyPlantErr;
			static const std::wstring cSubsysEmptySupErr;
			static const std::wstring cInvalidSubsysDesType;
			static const std::wstring cNoInterfaceErr;
			static const std::wstring cEmptyInterfaceErr;
			static const std::wstring cInterfaceNotImplementedErr;
			static const std::wstring cSubsysWithoutInterfErr;
	};

} //end of namespace DESpot
