/*************************************************************************
 * This file is part of the Distributed Computation feature
 *
 * Project created in conformity with the requirements for the Degree of
 * Master of Engineering in Software Engineering, Computing and Software
 * Department, McMaster University 2012
 *
 * Author:	David Kirby
 * Supervisor: Dr. Ryan Leduc
 *
 * Description: This class handles the triggering of the BDD HISC project
 * check algorithms and provides access to the error or success message
 * generated
 ************************************************************************/
#pragma once

#include <string>

#include "HierProjectPropCheck.h"

#include "qfileinfo.h"

#include "BddHiscMain.h"
#include "BddHisc.h"
#include "BddHiscErrmsg.h"

#include "DesInterface.h"

#include "DistCommon.h"

namespace DESpot 
{
	class BDDHandler 
	{
		public:
			BDDHandler(DesProject* project, AlgEnum alg, int subSystem);

		public:
			std::wstring getMsg();
			int runAlg();

		private:
			QString getSubSysName();
			std::wstring getInterf();

			int CheckAll(bool isHigh);
			int Ctrl(bool isHigh);
			int NonBlock(bool isHigh);
			int ICheck();
			int IConsis(bool isHigh);
			int Synth(char choice, bool isHigh);

		private:
			DesProject& m_project;
			DesHierProject& m_hierProject;
			AlgEnum m_alg;
			int m_subSystem;
			std::wstring m_msg;
	};
}