/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once	

namespace DESpot
{
	class UpdateProgressInterface
	{
		public:
			virtual void startProgress() = 0;

			virtual void updateProgress() = 0;

		    virtual void finishProgress() = 0;

		protected:
			UpdateProgressInterface(void){}
	};

	class ProgressUpdater
	{
		public:
			ProgressUpdater(UpdateProgressInterface* updateInterface) : m_update(updateInterface)
			{
				if (m_update)
				{
					m_update->startProgress();
				}
			}

			~ProgressUpdater()
			{
				if (m_update)
				{
					m_update->finishProgress();
				}
			}

			void update()
			{
				if (m_update)
				{
					m_update->updateProgress();
				}
			}
		
		private:
			UpdateProgressInterface* m_update;
	};	
}
