/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include <QAction>
#include <QMenu>
#include <QMenuBar>
#include <QToolBar>
#include <QStatusBar>
#include <qevent.h>
#include <QHeaderView>
#include <QFont>
#include <QHeaderView>

#include "EventPoolWorkspace.h"
#include "CommonDefinitions.h"
#include "EventPoolForm.h"
#include "EventPoolUiPart.h"


namespace DESpot
{

EventPoolWorkspace::EventPoolWorkspace(DesProject* proj, EventPoolForm* pEventPoolForm) : Workspace(pEventPoolForm)
{
	//configure the class to use the MainForm.ui
	setupUi(pEventPoolForm);

	m_uiPart = new EventPoolUiPart(this, proj);

	centralWidget->installEventFilter(this);
}

//_________________________________________________________________________________________________

EventPoolWorkspace::~EventPoolWorkspace(void)
{
	delete m_uiPart;
	m_uiPart = null;
}

//_________________________________________________________________________________________________

void EventPoolWorkspace::resize(QResizeEvent* /*event*/)
{
	//rezize the main layout to fit the editor content area
	QSize centralWidgSize = centralWidget->size();
}

//_________________________________________________________________________________________________

bool EventPoolWorkspace::eventFilter(QObject* target, QEvent* event)
{
	if (target == centralWidget && event->type() == QEvent::Resize)
	{
		QResizeEvent* resizeEvent = dynamic_cast<QResizeEvent*>(event);
		layoutWidget->resize(resizeEvent->size() - QSize(20, 22));
	}	

	return Workspace::eventFilter(target, event);
}

//_________________________________________________________________________________________________

EventPoolForm* EventPoolWorkspace::eventPoolForm()
{
	return dynamic_cast<EventPoolForm*>(form());
}

} //end of namespace DESpot
