/*************************************************************************
 * This file is part of Graphic des EDitor project    
 *
 * Project created in conformity with the requirements for the Degree of
 * Master of Engineering in Software Engineering, Computing and Software
 * Department, McMaster University 2004 - 2008
 *
 * Author:	Xiao Ma
 * Supervisor: Dr. Ryan Leduc
*************************************************************************/

/* 
 NAME
   GedDesDiagramInfo.h - Ged DES diagram information. 
 FUNCTION
   The class tracks the graphic information of the DES in editor. i.e, the
   position, shape, color of states and transition function in DES diagram 
   scene. The class keeps pointer of class Des and the pointer of diagram 
   items of its component.  Note the class does not save any proerties of 
   graphic items. These information is availe on the item classes.
 NOTES
 MODIFIED
   xma      03/01/08 - main change to add support to QGraphicsScene 
   xma	    09/01/07 - CREATION. Inital version adopted from DESpot by Magdin Stoica
*/

#pragma once

#include <QtGui>

#include "Workspace.h"
#include "ui_GedDesEditor.h"
#include "DesEvent.h"
#include "GedDesState.h"


namespace DESpot
{

class GedDesEditor;
class GedStateEditorUiPart;
class GedStateQuickLookUiPart;
class GedEventEditorUiPart;
class GedTransitionEditorUiPart;
class GedDesEditorOutputUiPart;
class Des;
class DesState;
class DesEvent;
class DesTransition;
class ProgressWidget;
class StateViewerWidget;
class DespotTreeWidget;
class EventViewerWidget;
class DespotTreeWidget;
class GedDesScene;
class GedDesState;

class GedDesWorkspace: public Workspace, private Ui::GedDesEditorUI
{
Q_OBJECT

public:
	GedDesWorkspace(GedDesEditor* pGedDesEditor, Des* pDes);
	virtual ~GedDesWorkspace(void);

	//public query functions
	GedDesScene *getScene() {return scene;}
	GedDesEditor* desEditor();
	GedStateEditorUiPart&		stateEditorUiPart();
	GedStateQuickLookUiPart&	stateQuickLookUiPart();
	GedEventEditorUiPart&		eventEditorUiPart();
	GedTransitionEditorUiPart&	transEditorUiPart();
	GedDesEditorOutputUiPart&	outputUiPart();

	QAction* recordTransAct();
	void resize(QResizeEvent* event);
	ProgressWidget* progressWidget();
	bool isGraphModified();
	
	void setMode();

signals:
	void setInstMode(bool);
public slots:
	void eventChanged(const DesEvent *ev);
	void eventDeletePrep(const DesEvent *ev);
	void eventDeleted(const DesEvent *ev);
	void saveAsPs(QString& fileName);
	void saveAsPng(QString& fileName);

private slots:
	//Graphic components
	void desCompButtonClicked(int id);
	void deleteItem();
	void editState();
	void editTransition();

	void pointerGroupClicked(int id);
	void stateInserted(GedDesState *item);
	void transInserted(GedDesTrans *item);
	void textInserted(QGraphicsTextItem *item);
	void sceneScaleChanged(const QString &scale);
	void saveAsImage();
	void saveAllAsPs();
	void saveAllAsPng();
	void saveAllTemplateAsPs();
	void saveAllTemplateAsPng();
	bool saveAllPrep();
	bool saveAllPrep2();

	void showGrid();

	//
	void onChangedCurrentState(const DesState* pNewCurrentState, 
		const DesState* pOldCurrentState);
	void updateCurrentStateUi(const DesState& crtState);
	void onChangedCurrentEvent(const DesEvent* pNewCurrentEvent, 
		const DesEvent* pOldCurrentEvent);
	void updateCurrentEventUi(const DesEvent& crtEvent);
	void onChangedCurrentTrans(const DesTransition* pNewCurrentTrans, 
		const DesTransition* pOldCurrentTrans);
	void updateCurrentTransUi(const DesTransition& crtTrans);
	void onChangedCurrentSelfTrans(const DesEvent* pNewCrtSelfTransEvent, 
		const DesEvent* pOldCrtSelfTransEvent);
//add by bini
	void DisableAll(bool);

private:
	void createActions();
	void createMenus();
	void createToolBox();
	void createToolbars();
	void createLayout();
	void populateDES();
	void createStateMenu();
	void createTransMenu();
	void setupStatusBar();
	void setupConnections();
	void positionSplitters();
	bool graphInfoExist(Des* des);

    QAction* getActionForEventType(EventType eventType);
	QWidget *createDesCompButton(const QString &text,
							  GedDesState::GedStateType type);

	QAction *addAction;
	QAction *deleteAction;
	QAction *editAction;

	QAction *editStateAction;
	QAction *editTransAction;
	QAction *toggleBackgroundGrid;

	//DES actions
	QAction* m_newDesAct;
	QAction* m_openDesAct;
	QAction* m_saveDesAct;
	QAction* m_saveDesAsAct;
	QAction* m_desSetNameAct;
	QAction* m_desSetTypeAct;
	QAction* m_printDesAct;
	QAction* m_closeGedDesEditorAct;

	//State actions
	QAction* m_addStateAct;
	QAction* m_changeStateAct;
	QAction* m_deleteStateAct;
	QAction* m_toggleMarkedStateAct;
	QAction* m_markAllStatesAct;
	QAction* m_unmarkAllStatesAct;
	QAction* m_toggleInitialStateAct;

	//Event actions
	QAction* m_addEventAct;
	QAction* m_changeEventAct;
	QAction* m_deleteEventAct;

	QAction* m_toggleEventCtrlAct;

	QActionGroup* m_setEventTypeActGroup;
	QAction* m_setEventTypeDefaultAct;
	QAction* m_setEventTypeAnswerAct;
	QAction* m_setEventTypeRequestAct;
	QAction* m_setEventTypeLDataAct;
	QAction* m_clearEventTypeAct;

	//Transition actions
	QAction* m_addTransAct;
	QAction* m_addSelfTransAct;
	QAction* m_changeTransAct;
	QAction* m_deleteTransAct;
	QAction* m_deleteSelfTransAct;
	QAction* m_recordTransAct;

	//Tools actions
	QAction* m_checkDesIntegAct;
	QAction* m_runReachToolAct;
	QAction* m_runCoreachToolAct;
	QAction* m_runNonblockToolAct;

	QAction* saveAsImageAction;
	QAction* saveAllAsPsAct;
	QAction* saveAllAsPngAct;
	QAction* saveAllTemplateAsPsAct;
	QAction* saveAllTemplateAsPngAct;
	QAction* restoreDefaultShapeAction;

	//help actions
	QAction* m_openHelpFileAct;
	QAction* m_aboutDespotAct;

	QMenu* m_desMenu;	
	QMenu* m_editMenu;
	QMenu* m_formatMenu;	
	QMenu* m_eventTypeSubMenu;
	QMenu* m_toolsMenu;
	QMenu* m_helpMenu;
	QMenu *stateContextMenu; //context menu for states
	QMenu *transContextMenu; //context menu for transition function
	QMenu *fileMenu;
	QMenu *itemMenu;
	QMenu *viewMenu;
	QMenu *aboutMenu;
	QMenu *exportSubMenu;
	QMenu *exportTemplateMenu;

	QToolBar *editToolBar;
	QToolBar *pointerToolbar;
	QToolBar* m_desToolBar;
	QToolBar* m_desToolsToolBar;

	QComboBox *sceneScaleCombo;

	QToolBox *toolBox;
	QButtonGroup *buttonGroup;
	QButtonGroup *pointerTypeGroup;

	GedStateEditorUiPart*		m_pStateEdUiPart;
	GedStateQuickLookUiPart*	m_pGedStateQuickLookUiPart;
	GedEventEditorUiPart*      m_pEventEdUiPart;
	GedTransitionEditorUiPart* m_pTransEdUiPart;
	GedDesEditorOutputUiPart*  m_pOutputUiPart;

	// We will do layout manually so need the handles of these Widgets
	StateViewerWidget* m_pStateViewWidg;
	DespotTreeWidget*  m_pStateQuickLookWidg;
	EventViewerWidget* m_pEventViewWidg;
	DespotTreeWidget* m_pTransViewWidg;
	DespotTreeWidget* m_pSelfTransViewWidg;

	QVBoxLayout *stateQuickLookLayout;
	QVBoxLayout *outputLayout;
	QVBoxLayout *centralLayout;

	GedDesScene *scene;               // Graphics scene
	QGraphicsView *view;              // Graphics view
	Des *myDes;

	QList<GedDesTrans *> transPendingUpdate; //to support deleting event

	double newScale;

};

} //end of namespace DESpot
