/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <map>
#include "Iterator.h"
#include "CommonDefinitions.h"
#include "DesInterface.h"


namespace DESpot
{
	//The interface iterator can iterate through the interfaces in a project
	class InterfaceIterator : public Iterator<DesInterface&, const DesInterface&>
	{
		public:
			InterfaceIterator(const std::map<std::wstring, DesInterface*>& interfMap):
						m_interfMap(interfMap)
			{
			}
		
			virtual ~InterfaceIterator(void)
			{
			}
	
		public:
			virtual void first() const
			{
				m_crtInterfIt = m_interfMap.begin();
			}
			
			virtual void next() const
			{
				m_crtInterfIt++;
			}
			
			virtual bool isDone() const
			{
				return (m_crtInterfIt == m_interfMap.end());
			}
			
			virtual DesInterface& currentItem()
			{
				if (m_crtInterfIt == m_interfMap.end())
					throw EX("Iterator is already done. Call isDone() before.")

				return const_cast<DesInterface&>(*(m_crtInterfIt->second));
			}
			
			virtual const DesInterface& currentItem() const
			{
				if (m_crtInterfIt == m_interfMap.end())
					throw EX("Iterator is already done. Call isDone() before.")

				return *(m_crtInterfIt->second);
			}


		private:
			//no copying allowed
			InterfaceIterator(const InterfaceIterator& other) : m_interfMap(other.m_interfMap) {}
			InterfaceIterator& operator=(const InterfaceIterator& /*other*/) { return *this; }

		private:
			typedef std::map<std::wstring, DesInterface*> InterfaceMap;
			typedef InterfaceMap::const_iterator InterfaceMapIt;

		private:
			const InterfaceMap m_interfMap;
			mutable InterfaceMapIt m_crtInterfIt;
	};

} //end of namespaces DESpot
