/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include "IntegrityAlgo.h"
#include "DesProject.h"

namespace DESpot
{
	class ProjIntegrityAlgo: public IntegrityAlgo
	{
		public:
			ProjIntegrityAlgo(bool runIncremental = true);
			ProjIntegrityAlgo(DesProject* project, bool runIncremental = true);
			virtual ~ProjIntegrityAlgo(void);

			void setInputProject(DesProject* project);

		//Verification methods: return true if the verification was succesfull and they
		//output warnings and errors in m_warnList and m_errList. Note a verification is
		//successful even if there are warnings
		//protected:
			//Overridable called from the "run" method of the base implementation of the algorithm
			virtual bool verifyIntegrity();

			//verifies the name of the project doesn't contain invalid characters
			virtual bool verifyProjectName();

			//verifies that project events are consistently defined in the constituent DES
			virtual bool verifyProjectEvents();

			//verifies that all DES are valid
			virtual bool verifyDes();

		protected:
			DesProject* m_project;

		private:
			static const std::wstring cProjIntegAlgoDesc;

			//Warnings
			static const std::wstring cInvalidProjNameWarn;

			//Errors
			static const std::wstring cInvalidProjectEventErr;

	};

} //end of namespace DESpot
