/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <map>
#include "CommonDefinitions.h"

namespace DESpot
{
	class DesSubsystem;
	class DesInterface;
	class Des;
	class Instantiation;
	
	class ProjectIndex
	{
		//Types
		public:
			enum ProjectCompType
			{
				eSubsystemComp,
				eInterfaceComp,
				eDesComp,
//add by bini
				eInstComp
			};

			typedef std::pair<ProjectCompType, const void*> TypedComp;

		public:
			ProjectIndex(void);
			~ProjectIndex(void);

		//Operations
		public:
			void addComp(const DesSubsystem& subsys);
			void addComp(const DesInterface& interf);
			void addComp(const Des& des);
//add by bini
			void addComp(const Instantiation& inst);

			bool findName(const std::wstring& name, TypedComp* out_comp = null);
			bool findSubsystem(const std::wstring& name, const DesSubsystem*& out_subsys);
			bool findInterface(const std::wstring& name, const DesInterface*& out_interf);
			bool findDes(const std::wstring& name, const Des*& out_des);
//add by bini
			bool findInstantiation(const std::wstring& name,const Instantiation*& out_inst);

			void reIndex(const std::wstring& oldName, const DesSubsystem& subsys);
			void reIndex(const std::wstring& oldName, const DesInterface& interf);
			void reIndex(const std::wstring& oldName, const Des& des);
//add by bini
			void reIndex(const std::wstring& oldName, const Instantiation& inst);

			void erase(const std::wstring& name);

		//Implementation	
		private:
			void addComp(const std::wstring& name, ProjectCompType compType, const void* comp);
			void reIndex(const std::wstring& oldName, const std::wstring& newName, ProjectCompType compType, const void* comp);

		//Implementation types	
		private:
			typedef std::multimap<std::wstring, TypedComp> NameIndexMap;
			typedef NameIndexMap::iterator NameIndexMapIt;

		private:
			NameIndexMap m_index;
	};

} //end of namespace DESpot
