/*************************************************************************
  FILE:   BddSdPubfunc.h
  DESCR: Header file for  BddSdPubfunc.cpp
  AUTH:  Raoguang Song, Yu Wang 
  DATE:  (C) Jan, 2006, 2009
*************************************************************************/
#ifndef ____BDDSDPUBFUNC_H____
#define ____BDDSDPUBFUNC_H____

#include <string>
#include "BddSdType.h"
#include "BddSdErrmsg.h"
#include <fdd.h>

using namespace std;

namespace BDDSD
{

#define VERBOSE(_level) if (iVerbLevel >= _level)
#define PRINT_DEBUG cout << DEBUG << __LINE__ << ": "


extern int giNumofBddNodes;
extern int iVerbLevel;

extern string str_trim(const string &str);
extern string str_upper(const string &str);
extern string str_lower(const string &str);
extern string str_itos(int iInt);
extern string str_ltos(long long lLong);

extern string str_nocomment(const string & str);
extern int scp_err(const string & sErr, const int iErrCode);

extern string GetNameFromFile(const string & vsFile);

extern int IsInteger(const string &str);
extern int CompareInt(const void* pa, const void* pb);

extern void bddPrintStats(const bddStat &stat);
extern void SetBddPairs(bddPair *pPair, const bdd & bddOld, const bdd & bddNew);
extern int NumofSharedEvents(const int * pEventsArr_a, const int viNumofEvents_a,
         const int * pEventsArr_b, const int viNumofEvents_b);
extern void my_bdd_gbchandler(int pre, bddGbcStat *s);

} //end of namespace BDDSD

#endif //____BDDSDPUBFUNC_H____
