#pragma once

namespace DESpot
{
	enum ProjectType
	{
		eFlatProject,
		eHierProject
	};

	enum ProjectCompType
	{
		eSubsystemComp,
		eInterfaceComp,
		eDesComp
	};

	enum ProjectLevel
	{
		eHighLevel,
		eInterfLevel,
		eLowLevel
	};

	enum DesLevel
	{
		eSupervisorDes,
		ePlantDes,
//add by bini
		eTemplateDes
//bini
	};

	enum DesType
	{
		eUnknownDes		= 0,
		eRegularDes		= 1,
		eSubsystemDes	= 2,
                eInterfaceDes	= 3,
		eInterfaceTemplateDes =4
	};


	enum Integrity
	{
		eIntegNotVerified = -1, 
		eIntegNo = 0,
		eIntegYes = 1
	};

	enum NonBlockingProp
	{
		eNonBlockNotVerified = -1,
		eNonBlockNo = 0,
		eNonBlockYes = 1
	};

	enum ControllableProp
	{
		eCtrlNotVerified = -1,
		eCtrlNo = 0,
		eCtrlYes = 1
	};

	enum IConsistProp
	{
		eIConsNotVerified = -1,
		eIConsNo = 0,
		eIConsYes = 1
	};

	enum LwNonBlockProp
	{
		eLwNonBlockNotVerified = -1,
		eLwNonBlockNo = 0,
		eLwNonBlockYes = 1
	};

	enum LwCtrlProp
	{
		eLwCtrlNotVerified = -1,
		eLwCtrlNo = 0,
		eLwCtrlYes = 1
	};

	enum ReachableProp
	{
		eReachableNotVerified = -1,
		eReachableNo = 0,
		eReachableYes = 1
	};

	enum EventType
	{
		eDefaultEvent = 0,
		eAnswerEvent = 1,
		eRequestEvent  = 2,
		eLDataEvent = 3,
		eHighLevelEvent = 4,
		eLowLevelEvent = 5,
		eLastEventType = 6
	};
    
    enum TransOpRes
    {
        eLocalSelfTransFound = 3,
        eTransFound			= 2,
        eTransOpOk			= 1,
        eTransNotFound		= 0,
        eNonDetTrans		= -1,
        eTransNonDetWithSelf = -2,
        eDuplicatedTrans    = -3,
        eInvalidFromState	= -4,
        eInvalidEvent		= -5,
        eInvalidToState		= -6
    };
    
	enum AlgoType
	{
		eLwNonBlock,
		eLwCtrl,
		eLwIConst
	};
//add by bini
	enum InputType
	{
		eRange,
		eTuple
	};

}
