/*************************************************************************
 * This file is part of the Distributed Computation feature
 *
 * Project created in conformity with the requirements for the Degree of
 * Master of Engineering in Software Engineering, Computing and Software
 * Department, McMaster University 2012
 *
 * Author:	David Kirby
 * Supervisor: Dr. Ryan Leduc
 *
 * Description: This class handles the triggering of flat project check
 * algorithms and provides access to the error list generated. It also 
 * keeps track of the number of blocking states for a nonblocking check,
 * but that feature is currently unused.
 ************************************************************************/
#pragma once

#include <string>
#include "FlatProjectPropCheck.h"
#include "MeetAlgo.h"
#include "DistCommon.h"

namespace DESpot 
{
	class FlatHandler
	{
		public:
			FlatHandler(DesProject* project, AlgEnum alg);

		public:
			DesAlgo::ErrorList getErrorList();

		public:
			bool runAlg();

		private:
			void SetCtrlErr(DESpot::MultiCtrlAlgo& ctrlAlgo);
			void SetNonBlockErr(DESpot::MultiNonBlockingAlgo& nonBlockAlgo);

		private:
			DesFlatProject& m_project;
			AlgEnum m_alg;	
			DesAlgo::ErrorList m_errList;
	};
}