/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

namespace DESpot
{

template<class ItemClass, class ConstItemClass>
class Iterator
{
	public:
		virtual void first() const = 0 ;
		virtual void next() const = 0 ;
		virtual bool isDone() const = 0 ;
		virtual ItemClass currentItem() = 0;
		
		virtual ConstItemClass currentItem() const  = 0;

		bool notDone() const 
		{
			return !isDone();
		}
	
	public:	
		virtual ~Iterator(void){}

	protected: 
		Iterator(void) {}
};


} //end of namespace DESpot
