/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <string>
#include <qthread.h>
#include "DesAlgo.h"
#include "DesHierProject.h"
#include "CounterExampleAlgo.h"
namespace DESpot
{	
	class HighSubsysNonBlockAlgo;
	class LowSubsysNonBlockAlgo;

	class LwNonBlockingAlgo : public DesAlgo, public QThread  
	{
		public:
			LwNonBlockingAlgo(DesHierProject& project, bool runIncremental = true);
			virtual ~LwNonBlockingAlgo(void);

		public:
			virtual bool runAlgo();

			virtual bool runAlgo(std::map<std::wstring, bool> &subsysNonBlockMap);

			bool isLwNonBlocking() const;

			void overrideLwNonBlocking(bool lwNonBlock);

			bool runAlgoOnExtractionSystem();

		protected:
			virtual void prepareRun();

			void clearAlgo();
				
			DesHierProject& m_project;
			// Added by Zain for Counter Example
		public:
			DesHierProject& getProject();
		protected:
			HighSubsysNonBlockAlgo* m_hNonBlockAlgo;
			
			std::vector<LowSubsysNonBlockAlgo*> m_lNonBLockAlgoList;

			bool m_isLwNonBlock;

		private:
			static const std::wstring cLwNonBlockAlgoDesc;
		    static const std::wstring cIntegrityNotConfirmed;
			static const std::wstring cProjectInvalid;
		public:
            virtual void run();
			bool verifyProjectIntegrity();
	};
}
