/*
 * SimGedViewerScene.h
 *
 *  Created on: Aug 7, 2009
 *      Author: alex
 */

#ifndef SIMGEDVIEWERSCENE_H_
#define SIMGEDVIEWERSCENE_H_

#include <QtGui/QWidget>
#include "GedDesHelper.h"

namespace DESpot
{
class Des;
class SimCompState;

class SimGedViewerScene : public QWidget
{
	Q_OBJECT

public:
	SimGedViewerScene(Des* pDes, QWidget* parent = 0);
	virtual ~SimGedViewerScene();

	void init();
	void updateView(SimCompState* pCurState, bool isRunningMode = true);
	void paintEvent(QPaintEvent *event);
	QRect  suggestGeometry();

protected:
	void deleteAllItems();

private slots:
	void switchState();
	void animate();

private:
	Des *m_pDes;
	GedDesHelper m_desHelper;
	QTimer* m_pAnimTimer;
	GedDesState* m_pCurGedState;
	GedDesTrans* m_pChosenTrans;
	GedDesTrans::GedSimType m_pChosenTransType;
	int m_animCount;
	SimCompState* m_pCurState;
	bool m_isRunningMode;
	QPointF m_itemOffset;
};

} // end of namespace

#endif /* SIMGEDVIEWERSCENE_H_ */
