/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include "DespotTreeWidget.h"
#include "DesState.h"

namespace DESpot
{
	class Des;

	class StateViewerWidget : public DespotTreeWidget
	{
		Q_OBJECT	
		
		public:
			StateViewerWidget(QWidget* parent = 0);
			~StateViewerWidget(void);

		public:
			virtual void initWidget();
			
			void setAllowEdit(bool allowEdit = true);
			
			void loadStates(Des* des);

			QTreeWidgetItem* addState(const DesState& state);
			QTreeWidgetItem* updateState(const DesState& state);
			void updateAllStates();
			void removeState(const DesState& state);


		//Signals_______________________________________
		signals:
			void onChangedCurrentState(const DesState* pNewCurrentState, const DesState* pOldCurrentState);
			void onChangedActiveState(const DesState* pNewCurrentState, const DesState* pOldCurrentState);
			void onStateClicked(const DesState& state);

			void onUserChangedStateName(const DesState& changedState, const std::wstring& newName);
			void onUserChangedStateAlias(const DesState& changedState, const std::wstring& newAlias);
			void onUserChangedStateInit(const DesState& changedState, bool newInit);
			void onUserChangedStateMarking(const DesState& changedState, bool newMarking);

		//Slots_________________________________________
		private slots:			
			void onChangedCurrentStateItem(QTreeWidgetItem* current, QTreeWidgetItem* previous);
			void onChangedActiveStateItem(QTreeWidgetItem* current, QTreeWidgetItem* previous);
			void onStateItemChanged ( QTreeWidgetItem * item, int column );
			void onStateItemClicked ( QTreeWidgetItem * item, int column );


		protected:
			virtual void resizeEvent(QResizeEvent* event);

		private:
			void setupConnections();
			void resizeHeaders(int stateViewWidgWidth);

			QTreeWidgetItem* createUiItemFromState(const DesState& state);
			void fillStateUiItem(QTreeWidgetItem& stateUiItem, const DesState& addedState);
			const DesState& getStateFromUiItem(QTreeWidgetItem& stateUiItem);
			QTreeWidgetItem* getUiItemFromState(const DesState& state);
			QTreeWidgetItem* getUiItemFromState(const DesState::ID& stateID);

		private:
			bool m_allowEdit;

		//constants
		private:
			static const short cStateEditorColumnCount;
			static const short cStateNameColumnIdx;
			static const short cStateAliasColumnIdx;
			static const short cStateInitColumnIdx;
			static const short cStateMarkedColumnIdx;
			
			static const QString cPropCheckSymbol;

			static const QString cStateNameColName;
			static const QString cStateAliasColName;
			static const QString cStateInitColName;
			static const QString cStateMarkedColName;

			static const QString cYes;
			static const QString cNo;
			static const QString cUnknown;

			static const QString cStateInitPropLabel;
			static const QString cStateMarkedPropLabel;
			static const QString cStateReachablePropLabel;


	};

} //end of namespace DESpot
