/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007


	Modified by Xu Han
*/
#pragma once

#include <string>
#include "MultiCtrlAlgo.h"
#include "OutputUiPart.h"
namespace DESpot
{
	class DesSubsystem;
	
	class SubsysReqAcceptAlgo : public MultiCtrlAlgo
	{
		//-----------data define-----------------------
		public:
			const DesSubsystem& m_subsystem;
		public:
			static const std::wstring cSubsysReqAcceptAlgoDesc;
			static const std::wstring cSubsysReqAcceptError;


       //------------interface define------------------

		public:
			SubsysReqAcceptAlgo(const DesSubsystem& subsystem);
			virtual ~SubsysReqAcceptAlgo(void);
		public:
			virtual bool runAlgo();
		    virtual void onEventBlocked(short eventId,  SrcStateTuple& srcStateTuple, short iSrc);
			bool allRequestEventsAccepted() const;
			std::wstring getError();
			bool isLowLevelDes(const Des* pDes, short iSrc);
		public:
			virtual void prepareRun();
		public:
			void addInputDes();

		


	};
}
