/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include "CheckProjectDlg.h"

namespace DESpot
{

CheckProjectDlg::CheckProjectDlg(ProjectType projType, QWidget* parent /*= null*/):
		QDialog(parent),
		m_projType(projType),
		m_checkValid(true),
		m_checkNonBlock(true),
		m_checkCtrl(true),
		m_checkIConsist(true),
		m_checkLwNonBlock(true),
		m_checkLwCtrl(true),
		m_incCheck(true)
{
	//call the UI base class to setup all controls
	setupUi(this);

	customizeUi();
	
	updateUi();
	
	connect(m_selectAllWidg, SIGNAL(clicked()), this,SLOT(onSelectAll()));
	connect(m_clearAllWidg, SIGNAL(clicked()), this,SLOT(onClearAll()));
}

//_________________________________________________________________________________________________

CheckProjectDlg::~CheckProjectDlg(void)
{
}

//_________________________________________________________________________________________________

bool CheckProjectDlg::checkValid()
{
	return m_checkValid;
}

//_________________________________________________________________________________________________

bool CheckProjectDlg::checkNonBlocking()
{
	assert(m_projType == eFlatProject);
	return m_checkNonBlock;
}

//_________________________________________________________________________________________________

bool CheckProjectDlg::checkCtrl()
{
	assert(m_projType == eFlatProject);
	return m_checkCtrl;
}

//_________________________________________________________________________________________________

bool CheckProjectDlg::checkIConsist()
{
	assert(m_projType == eHierProject);
	return m_checkIConsist;
}

//_________________________________________________________________________________________________

bool CheckProjectDlg::checkLwNonBlocking()
{
	assert(m_projType == eHierProject);
	return m_checkLwNonBlock;
}

//_________________________________________________________________________________________________

bool CheckProjectDlg::checkLwCtrl()
{
	assert(m_projType == eHierProject);
	return m_checkLwCtrl;
}

//_________________________________________________________________________________________________

bool CheckProjectDlg::checkIncremental()
{
	return m_incCheck;
}

//_________________________________________________________________________________________________

void CheckProjectDlg::customizeUi()
{
	m_checkNonBlockWidg->setVisible(m_projType == eFlatProject);
	m_checkCtrlWidg->setVisible(m_projType == eFlatProject);

	m_checkIConsistWidg->setVisible(m_projType == eHierProject);
	m_checkLwNonBlockWidg->setVisible(m_projType == eHierProject);
	m_checkLwCtrlWidg->setVisible(m_projType == eHierProject);

	//adjust the size of the dialog
	QSize offset;

	if (m_projType == eFlatProject)
	{
		offset.setHeight(75);
		offset.setWidth(0);
	}
	else
	{
		offset.setHeight(60);
		offset.setWidth(0);
	}

	QRect dlgRect = geometry();		
	dlgRect.setSize(dlgRect.size() - offset);
	//and re-center the dialog
	dlgRect.moveCenter(parentWidget()->geometry().center());

	setGeometry(dlgRect);

}

//_________________________________________________________________________________________________

//update the UI to show the current values of properties to be checked
void CheckProjectDlg::updateUi()
{
	m_checkValidWidg->setChecked(m_checkValid);
	m_checkNonBlockWidg->setChecked(m_checkNonBlock);
	m_checkCtrlWidg->setChecked(m_checkCtrl);
	
	m_checkIConsistWidg->setChecked(m_checkIConsist);
	m_checkLwNonBlockWidg->setChecked(m_checkLwNonBlock);
	m_checkLwCtrlWidg->setChecked(m_checkLwCtrl);
}

//_________________________________________________________________________________________________

void CheckProjectDlg::onSelectAll()
{
	m_checkValidWidg->setChecked(true);
	
	m_checkNonBlockWidg->setChecked(true);
	m_checkCtrlWidg->setChecked(true);
	
	m_checkIConsistWidg->setChecked(true);
	m_checkLwNonBlockWidg->setChecked(true);
	m_checkLwCtrlWidg->setChecked(true);
}

//_________________________________________________________________________________________________

void CheckProjectDlg::onClearAll()
{
	m_checkValidWidg->setChecked(false);
	
	m_checkNonBlockWidg->setChecked(false);
	m_checkCtrlWidg->setChecked(false);
	
	m_checkIConsistWidg->setChecked(false);
	m_checkLwNonBlockWidg->setChecked(false);
	m_checkLwCtrlWidg->setChecked(false);
}

//_________________________________________________________________________________________________

void CheckProjectDlg::accept()
{
	m_checkValid = m_checkValidWidg->isChecked();
	m_checkNonBlock = m_checkNonBlockWidg->isChecked();
	m_checkCtrl = m_checkCtrlWidg->isChecked();
	m_checkIConsist = m_checkIConsistWidg->isChecked();
	m_checkLwNonBlock = m_checkLwNonBlockWidg->isChecked();
	m_checkLwCtrl = m_checkLwCtrlWidg->isChecked();
	
	m_incCheck = m_incCheckWidg->isChecked();

	QDialog::accept();
}

} // end of namespace DESpot
