/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/
#pragma once
#include "DesProject.h"
#include "DistCommon.h"
//#include "InstantiateTemplate.h"
//#include "Instantiation.h"

namespace DESpot
{
	class Des;
	class Instantiation;
	class DesFlatProject :	public DesProject
	{
		public:
			DesFlatProject(const std::wstring& name);

			virtual ~DesFlatProject(void);

		//Des properties
		public:
			//returns the number of supervisor DES in the project
			int getSupDesCount();

			//returns the number of plant DES in the project
			int getPlantDesCount();
			//add by bini
			//returns the number of template DES in the project
			int getTemplateDesCount();
			//bool isTemplateName(const std::wstring& name);
			//bool tflag;
			//bool m_isTemplate;

		//Distributed computation method
		public:
			void setFlags(resultStruct rs);

		//Des editing
		public:
			virtual void changeDesName(Des& des, const std::wstring& newDesName);

			//adds a DES with the given type
			void addDes(Des* pDes, DesLevel desLevel);

			//adds a supervisor DES
			void addSupDes(Des* pSupDes);

			//adds a plant DES
			void addPlantDes(Des* pPlantDes);
			//add by bini

			//adds a template DES
			void addTemplateDes(Des* pTemplateDes);
			//int flag1;
			//bini
//add by bini
			bool addInstantiation(Instantiation* pInstantiation,Des* template_crt);

			//removes a DES (either plant or supervisor)
			void removeDes(Des* pDes);

			//removes a DES from the project and destroys it
			virtual void deleteDes(const std::wstring& desName);
//add by bini
			virtual void deleteInstantiation(const std::wstring& instName);
			void instantiatetemplate(const std::wstring& templateName,Instantiation* inst); 

			//InstantiateTemplate instantiatedlg;

	};

}; //end of namespace DESpot
