/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QDialog>

#include "CommonDefinitions.h"
#include "ui_DesStateEditorDialog.h"
#include "DesState.h"

namespace DESpot
{

class DesStateEditorDlg : public QDialog, public Ui::DesStateEditorDlgUI
{
	//Construction
	public:
		DesStateEditorDlg(QWidget *parent = null);
		DesStateEditorDlg(const DesState& state, QWidget *parent = null);
		virtual ~DesStateEditorDlg(void);

		// Add by XMA, required by graphic editor
		void setDefaultProps(bool initState, bool markedState);

	//Operations
	public:
		const DesState& resultState() const;

//add by bini
		bool state_isTemplate;
		bool isTemplate()
		{
			return state_isTemplate;
		}
		void setTemplate(bool is_Template)
		{
			state_isTemplate=is_Template;
		}

	//Overridables
	private:
		virtual void accept();
		virtual void reject();

	//Implementation Methods
	private:
		void UpdateUI();

	private:
		DesState m_state;

};

} //end of namespace DESpot
