/*************************************************************************
 * This file is part of the Distributed Computation feature
 *
 * Project created in conformity with the requirements for the Degree of
 * Master of Engineering in Software Engineering, Computing and Software
 * Department, McMaster University 2012
 *
 * Author:	David Kirby
 * Supervisor: Dr. Ryan Leduc
 ************************************************************************/
#include <QMessageBox>
#include <QDesktopServices>
#include "DistributedConfigDialog.h"

namespace DESpot
{
	DistributedConfigDialog::DistributedConfigDialog(QWidget* parent /*= null*/) : QDialog(parent)
	{
		setupUi(this);

		HostFileManager::loadHostFile();
		fillNodeBox();				
	}

//_________________________________________________________________________________________________

	DistributedConfigDialog::~DistributedConfigDialog(void)
	{
	}

//_________________________________________________________________________________________________

	void DistributedConfigDialog::fillNodeBox()
	{
		tb_nodes->clear();

		HostFileManager::first();
		while (!HostFileManager::done())
		{
			tb_nodes->appendPlainText(QString::fromStdString(HostFileManager::getCurrent()));
			HostFileManager::next();
		}
	}

//_________________________________________________________________________________________________

	void DistributedConfigDialog::accept()
	{
		QString nodes = tb_nodes->toPlainText();
		HostFileManager::saveHostFile(nodes.toStdString());		

		QDialog::accept();
	}

} //end of namespace DESpot
