/*************************************************************************
 * This file is part of Graphic des EDitor project
 *
 * Project created in conformity with the requirements for the Degree of
 * Master of Engineering in Software Engineering, Computing and Software
 * Department, McMaster University 2004 - 2008
 *
 * Author:	Xiao Ma
 * Supervisor: Dr. Ryan Leduc
*************************************************************************/

/*
 NAME
   GedDesState.h - Ged DES state class.
 FUNCTION
   The class provides the graphic representation of a DES state.
 NOTES
 MODIFIED
   xma	    09/01/07 - CREATION
*/

#ifndef GEDDESSTATE_H
#define GEDDESSTATE_H

#include <QGraphicsPixmapItem>
#include <QList>
#include <QPen>
#include "GedDesLabel.h"
#include "DesState.h"
#include "DesEvent.h"

class QPixmap;
class QGraphicsItem;
class QGraphicsScene;
class QTextEdit;
class QGraphicsSceneMouseEvent;
class QMenu;
class QGraphicsSceneContextMenuEvent;
class QPainter;
class QStyleOptionGraphicsItem;
class QWidget;
class QPolygonF;
class QAction;

namespace DESpot
{
class GedDesTrans;
class DiagramTextItem;

class GedDesState : public QGraphicsEllipseItem
{


public:
    enum { Type = UserType + 15 };
    enum GedStateType { InitState,MarkedState,InitMarkedState,RegularState};
    enum GedSimType { RegularSimState, CurrentSimState, EligibleSimState, IneligibleSimState };

	GedDesState(GedStateType desCompType, QMenu *contextMenu,
        QGraphicsItem *parent = 0, QGraphicsScene *scene = 0);
	GedDesState(const DesState& state, QMenu *contextMenu,
        QGraphicsItem *parent = 0, QGraphicsScene *scene = 0);

	~GedDesState();

	void setMenu(QMenu* menu) { contextMenu = menu; }

    void removeGedDesTrans(GedDesTrans *tran);
    void removeGedDesTrans();
    GedStateType desCompType() const
        { return gedStateType; }
    QPolygonF polygon() const
        { return rect; }
    void addGedDesTrans(GedDesTrans *tran);

	const QList<GedDesTrans *>& getTrans() const
		{return trans;}
    QPixmap image() const;
    int type() const
        { return Type;}
	void setStateType(GedStateType type, bool toSet);
	void setSimType(GedSimType type);

	//Des related
	void setDesState(const DesState* state)
		{desState = state;}
	const DesState* getDesState()
		{return desState;}
	void updateState();
	QPointF labelPos() const
		{return label->pos();}
	void setLabelPos(QPointF labelPos)
		{label->setPos(labelPos);}
	QRectF labelboundingRect() const
        	{return label->boundingRect();}
	void addTrans(const DesEvent *ev, const GedDesTrans *tran)
	  {transMap.insert(ev,tran);}
	const GedDesTrans* gedTrans(const DesEvent *event) const;

	bool isReadOnly() const { return !((flags() & QGraphicsItem::ItemIsMovable) && (flags() & QGraphicsItem::ItemIsSelectable)); }
	void setReadOnly(bool readOnly);

	void draw(QPainter* painter, QPointF& offset);

protected:
    void contextMenuEvent(QGraphicsSceneContextMenuEvent *event);
    QVariant itemChange(GraphicsItemChange change, const QVariant &value);
	void paint(QPainter *painter, const QStyleOptionGraphicsItem *option,
               QWidget *widget = 0);
	void drawState(QPainter* painter, bool simMode);

private:
	void setType(GedStateType type)
		{gedStateType=type;}

    GedStateType gedStateType;
    GedSimType gedSimType;
    QRectF rect;
    QMenu *contextMenu;
    QList<GedDesTrans *> trans;
	QMap<const DesEvent*,const GedDesTrans*> transMap;
	GedDesLabel *label;
	const DesState *desState;

};
}
#endif
