/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QMainWindow>
#include "DespotForm.h"
#include <QtXml/QDomDocument>

class QAction;
class QMenu;
class QToolBar;						   
class QFile;

namespace DESpot
{

class MainWorkspace;
class ProjectEditor;
class DesEditor;
class Des;


class MainForm   : public QMainWindow, public DespotForm
{
	Q_OBJECT

	public:
		MainForm(void);
		virtual ~MainForm(void);
    
	public:
		bool editorOpened(const QString& fileName, DesEditor*& out_desEditor);
		bool editorOpened(Des* des, DesEditor*& out_desEditor);
		bool editorOpened(const QString& fileName, ProjectEditor*& out_desEditor);

	public slots:
		//Project Operations
		void onNewFlatProject();
		void onNewHiscProject();
		void onOpenProject();
		void onOpenProject(const QString& fileName);
        void onNewRegressionTest();
        void onOpenRegressionTest();
        //void onOpenRegressionTest(const QString& fileName);

		//DES Operations
		void onNewDes();
		void onOpenDes();
		void onOpenDes(const QString& fileName);

		#ifdef __ENABLE_NEXT_VERSION__
			//Workspace Operations
			void onOpenWorkspace();
			void onSaveWorkspace();
			void onOpenRecentWorkspace();
		#endif

		//General Operations
		void onExitApplication();
		
		//Windows Operations
		#ifdef __ENABLE_NEXT_VERSION__
			void onCascadeSelWindows();
			void onTileHorizSelWindows();
			void onTileVertSelWindows();
			void onCascadeAllWindows();
			void onTileHorizAllWindows();
			void onTileVertAllWindows();
		#endif

		//Help Operations
		void onOpenHelpFile();
		void onAboutDespot();

		//Internal slot called whenever a despot form is opened by the form itself
		//This slot is used to fire specific signals which in turn should populate
		//the recently used projects, des and opened windows
		void onOpenForm(DespotForm* form);
		bool onCloseForm(DespotForm* form);

	public:
		static bool getOpenFileName(QWidget * parent, const QString & caption, const QString & filter, QString& out_fileName);
		static bool getSaveFileName(QWidget * parent, const QString & caption, const QString & filter, QString& io_fileName);

	protected:
		 void closeEvent(QCloseEvent *event);

	signals:
		 void onFormOpened(DespotForm* form);
		 void onFormClosed(DespotForm* form, bool& okToClose);
		 void onDocumentFormOpened(DespotForm* form);
		 void onDocumentFormClosed(DespotForm* form);

	private:
		void loadConfig();
		void saveConfig();
		void createConfigFile(QFile& configFile);
		QString getConfigFileFullPath();

	private:
		MainWorkspace* m_pWorkspace;

		//configuration data
		QDomDocument m_configDoc;

		static QString m_lastUsedFileDir;

	public:
		static const QString cConfigFolder;	
		static const QString cConfigFileName;
		static const QString cConfigRootTag;
		static const QString cConfigVerAttr;
		static const QString cDespotVersion;
		static const QString cRecentProjTag;
		static const QString cRecentDesTag;
		static const QString cMainFormName;
};

} //end of namespace DESpot
