/*	Author:		Dr. Ryan Leduc
	
*/

#pragma once
//#include <iostream>
#include "BDDDefaultFTAlgoTimed.h"
#include "Des.h"
#include "DesFlatProject.h"
#include "FlatDummyProject.h"
#include "MultiCtrlAlgo.h"
#include "FlatProjIntegrityAlgo.h"
#include "BddSdMain.h"

namespace DESpot
{
BDDDefaultFTAlgoTimed::BDDDefaultFTAlgoTimed(const DesProject& currentProject, QList<QString>& currentFaultSet): DefaultFTAlgoTimed(currentProject, currentFaultSet),m_isTimedBDDDFTControllable(false)
{
	GFDes = NULL;
	m_flatDummyProject = NULL;
}
//____________________________________________________________________________________________________________________________________	
BDDDefaultFTAlgoTimed::~BDDDefaultFTAlgoTimed()
{
}
//____________________________________________________________________________________________________________________________________
BDDSD::SD_TCtrlChkInfo BDDDefaultFTAlgoTimed::runTimedBDDFTCtrlAlgo()
{

	// check that excluded fault set is valid
	if (! (m_currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  

	if (! m_faultSet.isEmpty())	
	{
		DefaultFTAlgo::createDummyFlatProject();
		DefaultFTAlgo::constructGFTimed();
		DefaultFTAlgo::addGF();  
		return BDDDefaultFTAlgoTimed::verifyTimedBDDFTCtrl();

	}
	else {
	   throw EX("There are no excluded fault events. Please run the standard controllability algorithm.");
	}

}
//____________________________________________________________________________________________________________________________________
BDDSD::SD_TCtrlChkInfo BDDDefaultFTAlgoTimed::verifyTimedBDDFTCtrl()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		int tmp;
		BDDSD::SD_TCtrlChkInfo  checkInfo("Project passes Timed  Controllability Check");
      		tmp = BddSdCheckTCtrl((DesProject&) *m_flatDummyProject, checkInfo);

     		if (checkInfo.m_chkPassed)
			m_isTimedBDDDFTControllable = true;
		else
			m_isTimedBDDDFTControllable = false;

		return checkInfo;
	}
	else
	{throw EX("Project Integrity test has failed");}
}
//____________________________________________________________________________________________________________________________________
bool BDDDefaultFTAlgoTimed::isTimedBDDDFTControllable() const
{
	return m_isTimedBDDDFTControllable;
}
//____________________________________________________________________________________________________________________________________
}


