/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2016
*/
#pragma once
#include <iostream>
#include "BDDNFaultsAlgo.h"
#include "Des.h"
#include "DesProject.h"
#include "FlatDummyProject.h"
#include "FlatProjIntegrityAlgo.h"
#include "BddSdMain.h"


namespace DESpot

{
BDDNFaultsAlgo::BDDNFaultsAlgo(const DesProject& currentProject, QList<QString>& faultSet, int N , QMultiMap<int,QString>& faultSets): NFaultsAlgo(currentProject, faultSet, N, faultSets), m_isBDDNFaultsControllable(false)
{
	GNFDes = NULL;
}
//____________________________________________________________________________________________________________________________________	
BDDNFaultsAlgo::~BDDNFaultsAlgo()
{
}
//____________________________________________________________________________________________________________________________________

BDDSD::SD_CtrlChkInfo BDDNFaultsAlgo::runBDDFTCtrlAlgo()
{
	DefaultFTAlgo::createDummyFlatProject();
	if (! m_faultSet.isEmpty())
	{
		DefaultFTAlgo::constructGF();	
		DefaultFTAlgo::addGF();
	}
	int m = m_faultSets.uniqueKeys().size();
	if (m_N < m)
	{
		NFaultsAlgo::constructGNF();
		NFaultsAlgo::addGNF();
	}	
	return BDDNFaultsAlgo::verifyBDDFTCtrl();
}
//____________________________________________________________________________________________________________________________________
BDDSD::SD_CtrlChkInfo BDDNFaultsAlgo::verifyBDDFTCtrl()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		int tmp;
		BDDSD::SD_CtrlChkInfo  checkInfo("Project passes Untimed Controllability Check");
      		tmp = BddSdCheckCtrl((DesProject&) *m_flatDummyProject, checkInfo);
     		if (checkInfo.m_chkPassed)
			m_isBDDNFaultsControllable = true;
		else
			m_isBDDNFaultsControllable = false;

		return checkInfo;
	}
	else
	{throw EX("Project Integrity test has failed");}

}
//____________________________________________________________________________________________________________________________________
bool BDDNFaultsAlgo::isBDDNFaultsControllable() const
{return m_isBDDNFaultsControllable;}

}


