/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2016
*/
#pragma once
#include <iostream>
#include "BDDNonRepFTAlgo.h"
#include "Des.h"
#include "DesProject.h"
#include "FlatDummyProject.h"
#include "FlatProjIntegrityAlgo.h"
#include "BddSdMain.h"


namespace DESpot
{
BDDNonRepFTAlgo::BDDNonRepFTAlgo(const DesProject& currentProject, QList<QString>& faultSet ,int M, int N , QMultiMap<int,QString>& faultSets) : NonRepFTAlgo(currentProject, faultSet , M , N , faultSets), m_isBDDNonRepFTControllable(false)
{
}
//____________________________________________________________________________________________________________________________________	
BDDNonRepFTAlgo::~BDDNonRepFTAlgo()
{
}
//____________________________________________________________________________________________________________________________________
BDDSD::SD_CtrlChkInfo BDDNonRepFTAlgo::runBDDFTCtrlAlgo()
{
	DefaultFTAlgo::createDummyFlatProject();
	if (! m_faultSet.isEmpty())
	{	
		DefaultFTAlgo::constructGF();
		DefaultFTAlgo::addGF();
	}
	if (m_N < m_M)
	{
		NonRepFTAlgo::constructGNF();
		NonRepFTAlgo::addGNF();
	}
	if (m_N > 0)
	{
		NonRepFTAlgo::constructGFi();
	}
	return BDDNonRepFTAlgo::verifyBDDFTCtrl();
}
//____________________________________________________________________________________________________________________________________
BDDSD::SD_CtrlChkInfo BDDNonRepFTAlgo::verifyBDDFTCtrl()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		int tmp;
		BDDSD::SD_CtrlChkInfo  checkInfo("Project passes Untimed Controllability Check");
      		tmp = BddSdCheckCtrl((DesProject&) *m_flatDummyProject, checkInfo);
     		if (checkInfo.m_chkPassed)
			m_isBDDNonRepFTControllable = true;
		else
			m_isBDDNonRepFTControllable = false;

		return checkInfo;
	}
	else
	{throw EX("Project Integrity test has failed");}

}
//____________________________________________________________________________________________________________________________________
bool BDDNonRepFTAlgo::isBDDNonRepFTControllable() const
{return m_isBDDNonRepFTControllable;}
}



