/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2016
*/
#pragma once
#include <iostream>
#include "BDDResetFTAlgoTimed.h"
//#include "DefaultFTAlgoTimed.h"
//#include "DefaultFTAlgo.h"
#include "Des.h"
#include "DesProject.h"
#include "FlatDummyProject.h"
#include "FlatProjIntegrityAlgo.h"
#include "BddSdMain.h"


namespace DESpot
{
BDDResetFTAlgoTimed::BDDResetFTAlgoTimed(const DesProject& currentProject, QList<QString>& faultSet ,int M , QMultiMap<int, QString>& faultSets, QMultiMap<int, QString>& resetSets) : ResetFTAlgoTimed(currentProject, faultSet, M , faultSets, resetSets), m_TimedBDDResetFaultsControllable(false)
{
}
//____________________________________________________________________________________________________________________________________	
BDDResetFTAlgoTimed::~BDDResetFTAlgoTimed()
{
}
//____________________________________________________________________________________________________________________________________
BDDSD::SD_TCtrlChkInfo BDDResetFTAlgoTimed::runTimedBDDFTCtrlAlgo()
{
	DefaultFTAlgo::createDummyFlatProject();
	if (! m_faultSet.isEmpty())
	{
		DefaultFTAlgo::constructGFTimed();
		DefaultFTAlgo::addGF();
	}
	ResetFTAlgoTimed::constructGTFi();
	return BDDResetFTAlgoTimed::verifyTimedBDDFTCtrl();
}
//____________________________________________________________________________________________________________________________________
BDDSD::SD_TCtrlChkInfo BDDResetFTAlgoTimed::verifyTimedBDDFTCtrl()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		int tmp;
		BDDSD::SD_TCtrlChkInfo  checkInfo("Project passes Untimed Controllability Check");
      		tmp = BddSdCheckTCtrl((DesProject&) *m_flatDummyProject, checkInfo);

     		if (checkInfo.m_chkPassed)
			m_TimedBDDResetFaultsControllable = true;
		else
			m_TimedBDDResetFaultsControllable = false;

		return checkInfo;
	}
	else
	{throw EX("Project Integrity test has failed");}

}
//____________________________________________________________________________________________________________________________________
bool BDDResetFTAlgoTimed::isTimedBDDResetFaultsControllable() const
{return m_TimedBDDResetFaultsControllable;}
}


