/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QMenu>

#include "Workspace.h"
#include "ui_DesEditor.h"
#include "DesEvent.h"

class QResizeEvent;

namespace DESpot
{

class DesEditor;
class StateEditorUiPart;
class StateQuickLookUiPart;
class EventEditorUiPart;
class TransitionEditorUiPart;
class DesEditorOutputUiPart;
class Des;
class DesState;
class DesEvent;
class DesTransition;
class ProgressWidget;


class DesWorkspace: public Workspace, private Ui::DesEditorUI
{
	Q_OBJECT

	public:
		DesWorkspace(DesEditor* pDesEditor, Des* pDes);
		virtual ~DesWorkspace(void);

	public:
		DesEditor* desEditor();

		StateEditorUiPart&		stateEditorUiPart();
		StateQuickLookUiPart&	stateQuickLookUiPart();
		EventEditorUiPart&		eventEditorUiPart();
		TransitionEditorUiPart& transEditorUiPart();
		DesEditorOutputUiPart&  outputUiPart();

		QAction* recordTransAct();

		void resize(QResizeEvent* event);

		ProgressWidget* progressWidget();
		void setMode(bool isInstantiation);
signals:
		void setInstMode(bool);

	private slots:
		void onChangedCurrentState(const DesState* pNewCurrentState, const DesState* pOldCurrentState);
		void updateCurrentStateUi(const DesState& crtState);
		
		void onChangedCurrentEvent(const DesEvent* pNewCurrentEvent, const DesEvent* pOldCurrentEvent);
		void updateCurrentEventUi(const DesEvent& crtEvent);

		void onChangedCurrentTrans(const DesTransition* pNewCurrentTrans, const DesTransition* pOldCurrentTrans);
		void updateCurrentTransUi(const DesTransition& crtTrans);

		void onChangedCurrentSelfTrans(const DesEvent* pNewCrtSelfTransEvent, const DesEvent* pOldCrtSelfTransEvent);

		void DisableAll(bool); 

	//Implementations Methods_______________________
	private:
		void createUiParts(DesEditor* pDesEditor, Des* pDes);
		void createActions();
		void setupMenu();
		void setupToolBar();
		void setupStatusBar();

		void setupConnections();
		void positionSplitters();
		
		QAction* getActionForEventType(EventType eventType);


	//UI Parts______________________________________
	private:
		StateEditorUiPart*		m_pStateEdUiPart;
		StateQuickLookUiPart*	m_pStateQuickLookUiPart;
		EventEditorUiPart*      m_pEventEdUiPart;
		TransitionEditorUiPart* m_pTransEdUiPart;
		DesEditorOutputUiPart*  m_pOutputUiPart;

	//Actions_______________________________________
	private:
		//DES actions
		QAction* m_newDesAct;
		QAction* m_openDesAct;
		QAction* m_saveDesAct;
		QAction* m_saveDesAsAct;
		QAction* m_revertToFileAct;
		QAction* m_desSetNameAct;
		QAction* m_desSetTypeAct;
		QAction* m_printDesAct;
		QAction* m_closeDesEditorAct;

		//State actions
		QAction* m_addStateAct;
		QAction* m_changeStateAct;
		QAction* m_deleteStateAct;
		QAction* m_toggleMarkedStateAct;
		QAction* m_markAllStatesAct;
		QAction* m_unmarkAllStatesAct;
		QAction* m_toggleInitialStateAct;

		#ifdef __ENABLE_NEXT_VERSION__				
			QActionGroup* m_sortStatesActGroup;
			QAction* m_sortStatesByNameAct;
			QAction* m_sortStatesByCreationAct;
			QAction* m_sortStatesByUserDefAct;
		#endif

		//Event actions
		QAction* m_addEventAct;
		QAction* m_changeEventAct;
		QAction* m_deleteEventAct;

		QAction* m_toggleEventCtrlAct;

		QActionGroup* m_setEventTypeActGroup;
		QAction* m_setEventTypeDefaultAct;
		QAction* m_setEventTypeAnswerAct;
		QAction* m_setEventTypeRequestAct;
		QAction* m_setEventTypeLDataAct;
		QAction* m_clearEventTypeAct;

		#ifdef __ENABLE_NEXT_VERSION__				
			QActionGroup* m_sortEventsActGroup;
			QAction* m_sortEventsByNameAct;
			QAction* m_sortEventsByCtrlAct;
			QAction* m_sortEventsByTypeAct;
			QAction* m_sortEventsByCreationAct;
			QAction* m_sortEventsByUserDefAct;
		#endif

		//Transition actions
		QAction* m_addTransAct;
		QAction* m_addSelfTransAct;
		QAction* m_changeTransAct;
		QAction* m_deleteTransAct;
		QAction* m_deleteSelfTransAct;
		QAction* m_recordTransAct;

		#ifdef __ENABLE_NEXT_VERSION__		
			QActionGroup* m_sortTransActGroup;
			QAction* m_sortTransByFromStateAct;
			QAction* m_sortTransByToStateAct;
			QAction* m_sortTransByEventNameAct;
			QAction* m_sortTransByEventTypeAct;
			QAction* m_sortTransByEventCtrlAct;
			QAction* m_sortTransByCreationAct;
			QAction* m_sortTransByUserDefAct;
		#endif

		//Tools actions
		QAction* m_checkDesIntegAct;
		QAction* m_runReachToolAct;
		QAction* m_runCoreachToolAct;
		QAction* m_runNonblockToolAct;
		
		#ifdef __ENABLE_NEXT_VERSION__		
			QAction* m_runIsomorphToolAct;
			QAction* m_runMultiTools;
		#endif

		//Help actions
		QAction* m_openHelpFileAct;
		QAction* m_aboutDespotAct;

		#ifdef __ENABLE_NEXT_VERSION__				
			//User Defined Order actions (used only in toolbar)
			QAction* m_moveFirstAct;
			QAction* m_moveUpAct;
			QAction* m_moveDownAct;
			QAction* m_moveLastAct;
		#endif

	//Menus_________________________________________
	private:
		QMenu* m_desMenu;
		
		QMenu* m_statesMenu;
		QMenu* m_sortStatesBySubMenu;
		
		QMenu* m_eventsMenu;
		QMenu* m_eventTypeSubMenu;
		QMenu* m_sortEventsBySubMenu;

		QMenu* m_transMenu;
		QMenu* m_sortTransBySubMenu;

		QMenu* m_toolsMenu;

		QMenu* m_helpMenu;

	//Tool Bars_________________________________________
	private:
		QToolBar* m_desToolBar;
		QToolBar* m_desToolsToolBar;
		
		#ifdef __ENABLE_NEXT_VERSION__		
			QToolBar* m_userDefOrdToolBar;
		#endif
};

} //end of namespace DESpot
