/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include "CommonDefinitions.h"
#include "ProjectWorkspace.h"
#include "ui_HierProjectEditor.h"

namespace DESpot
{

	class HierProjectEditor;
	class DesHierProject;
	class HierProjStructureUiPart;
	class HierProjSummaryUiPart;
	class DesSubsystem;
	class DesInterface;

	class HierProjectWorkspace: public ProjectWorkspace, private Ui::HierProjectEditorUI
	{
		Q_OBJECT

		public:
			HierProjectWorkspace(HierProjectEditor* pHierProjectEditor, DesHierProject* pProject);
			virtual ~HierProjectWorkspace(void);

		//Access to UI parts
		public:
			HierProjStructureUiPart& hierProjStructureUiPart();
			HierProjSummaryUiPart&   hierProjSummaryUiPart();

			virtual ProgressWidget* progressWidget();

			void selectDefaults();

		//Overridables__________________________________
		protected:
			virtual bool eventFilter(QObject* target, QEvent* event);
			virtual void onChangedCurrentDes(Des* pNewCrtDes, Des* pOldCrtDes);

		private slots:
			void onChangedCurrentSubsys(const DesSubsystem* pNewCrtSubsys, const DesSubsystem* pOldCrtSubsys);
			void onChangedCurrentInterf(const DesInterface* pNewCrtInterf, const DesInterface* pOldCrtInterf);


		//Implementations Methods ____________________________
		private:
			HierProjectEditor* hierProjectEditor();
			
			void setupConnections();

			void createUiParts(DesHierProject* pProject);
			void createActions();
			void setupMenu();
			void setupToolBar();
			void setupStatusBar();

			void setupEventFilters();
			void positionSplitters();

		//Actions_____________________________________________
		private:
			QAction* m_addHighLvlSubsysAct;
			QAction* m_addInterfaceAct;
			QAction* m_addLowLvlSubsysAct;
			QAction* m_projCompRenameAct;
			QAction* m_projCompDeleteAct;

			QAction* m_addNewSubsystemDesAct;
			QAction* m_addNewInterfaceDesAct;

			QAction* m_runContextSync;
			QAction* m_runProjIConsistToolAct;
			QAction* m_runSubsysIConsistToolAct;
			QAction* m_runCheckInterfToolAct;
			QAction* m_runSubsysNonBlockAct;
			QAction* m_runSubsysCtrlAct;
			QAction* m_runLevelWiseNonBlockAct;
			QAction* m_runLevelWiseCtrlAct;
			QAction* m_runLevelWiseSynthesisAct;

			//Added by Zain for subsystem simulation
			QAction* m_runSubsysSimulationAct;

			//Added by Adam for BDDExport
			QAction* m_exportToBDDhiscAct;

			#ifdef __ENABLE_BDD__
				QAction* m_runBddNonblockToolAct;
				QAction* m_runBddCtrlToolAct;
				QAction* m_runBddProjIConsistToolAct;
				QAction* m_runBddSubsysIConsistToolAct;
				QAction* m_runBddCheckAllToolAct;
				QAction* m_runBddCheckInterfToolAct;
				QAction* m_runBddSubsysNonBlockAct;
				QAction* m_runBddLevelWiseNonBlockAct;
				QAction* m_runBddLevelWiseCtrlAct;
				QAction* m_runBddSubsysCtrlAct;
				QAction* m_runBddLevelWiseSynthesisAct;
				QAction* m_runSubsysLWSynAct;
			#endif

			// Added by David for Distributed tools
			QAction* m_runDistCheckAll;
			QAction* m_runDistNB;
			QAction* m_runDistCtrl;
			QAction* m_runDistIConsist;

			QAction* m_runDistBDDCheckAll;
			QAction* m_runDistBDDNB;
			QAction* m_runDistBDDCtrl;
			QAction* m_runDistBDDIConsist;

			QAction* m_runDistBDDSynth;

		//Menus______________________________________________
		private:
			QMenu* m_subsysMenu;
			QMenu* m_addSubSysMenu;

		//UI Parts_______________________________
		private:
};

} //end of namespace DESpot
