/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include "ProgressWidget.h"

namespace DESpot
{

const int ProgressWidget::cMin = 0;
const int ProgressWidget::cMax = 5;

ProgressWidget::ProgressWidget(QWidget* parent) : QProgressBar(parent)
{
	setupProgressBar();
}

//_________________________________________________________________________________________________

ProgressWidget::~ProgressWidget(void)
{
}

//_________________________________________________________________________________________________

void ProgressWidget::startProgress()
{	
	//set the range: the status bar is going to cycle through the bar until the
	//operation is finished so the range cannot be too big
	setMinimum(cMin);
	setMaximum(cMax); 

	setValue(cMin);

	show();
}

//_________________________________________________________________________________________________

void ProgressWidget::updateProgress()
{
	int currentValue = value();
	int nextValue = (currentValue + 1) % (cMax + 1);
	setValue(nextValue);
}

//_________________________________________________________________________________________________

void ProgressWidget::finishProgress()
{
	setValue(cMax);
	hide();
}

//_________________________________________________________________________________________________

void ProgressWidget::setupProgressBar()
{
	//it shows no text because it is a cycling progress bar it doesn't show percentage complete
	setTextVisible(false);

	//set the range: the status bar is going to cycle through the bar until the
	//operation is finished so the range cannot be too big
	setMinimum(cMin);
	setMaximum(cMax); 

	//before the progress starts the progress bar is supposed to be hidden
	setVisible(false);
}

} //end of namespace DESpot
