/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2015
*/

#include <iostream> for debugging
#include <string> 
#include "ResetFTAlgo.h"
#include "Des.h"
#include "DesFlatProject.h"
#include "FlatDummyProject.h"
#include "MultiCtrlAlgo.h"
#include "FlatProjIntegrityAlgo.h"

namespace DESpot
{
ResetFTAlgo::ResetFTAlgo(const DesProject& currentProject, QList<QString>& faultSet, int M , QMultiMap<int,QString>& faultSets, QMultiMap<int, QString>& resetSets): DefaultFTAlgo(currentProject, faultSet), m_M(M), m_faultSets(faultSets),m_resetSets(resetSets), m_isResetFaultsControllable(false)
{
}
//____________________________________________________________________________________________________________________________________	
ResetFTAlgo::~ResetFTAlgo()
{
}
//____________________________________________________________________________________________________________________________________

bool ResetFTAlgo::runAlgo()
{
	DefaultFTAlgo::createDummyFlatProject();
	if (! m_faultSet.isEmpty())
	{
		DefaultFTAlgo::constructGF();
		DefaultFTAlgo::addGF();
	}
	ResetFTAlgo::constructGTFi();
	return ResetFTAlgo::verifyFTCtrl();

}
//____________________________________________________________________________________________________________________________________
void ResetFTAlgo::constructGTFi()
{
	if (! m_faultSets.empty())
	{
		int i = 1;
		while ( i <= m_M)
		{
			string temp;
			ostringstream convert;
			convert << i;
			temp = convert.str();
			std::wstring wsi;
			std::wstring wsi2 = L"GTFi" ;
			wsi.assign(temp.begin(), temp.end());
			wsi2.append(wsi);
			const std::wstring& name =wsi2;
			Des* GTFiDes;
			GTFiDes = new Des(name , eRegularDes);

			DesState* state1 = new DesState(0);
			state1->setIDasName();
			const DesState& InState1 = GTFiDes->addState(const_cast<DesState&>(*state1));
			GTFiDes->changeStateMarking(InState1.getId(),true);
			GTFiDes->changeStateInit(InState1.getId(),true);

			DesState* state2 = new DesState(1);
			state2->setIDasName();
			const DesState& InState2 = GTFiDes->addState(const_cast<DesState&>(*state2));
			GTFiDes->changeStateMarking(InState2.getId(),true);


			QList<QString> faultEvents = m_faultSets.values(i);
			for (int j=0 ; j < faultEvents.size() ; j++)
			{ 
				QString eventName = faultEvents.at(j);
				const DesEvent* event;
				DesProject::DesIteratorPtr DESIt = m_currentProject.createDesIterator();
				for(DESIt->first(); DESIt->isDone() == false; DESIt->next())
				{
					const Des& currentDes = DESIt->currentItem();
					if (currentDes.findEvent(eventName.toStdWString(),event))
					{
						const DesEvent& newEvent = GTFiDes->addEvent(const_cast<DesEvent&>(*event));
						DesTransition* trans = new DesTransition(InState1 , newEvent , InState2);
						GTFiDes->addTransition(const_cast<DesTransition&>(*trans));
						break;
					}
				}

			}

			QList<QString> resetEvents = m_resetSets.values(i);
			for (int j=0 ; j < resetEvents.size() ; j++)
			{ 
				QString eventName = resetEvents.at(j);
				const DesEvent* event;
				DesProject::DesIteratorPtr DESIt = m_currentProject.createDesIterator();
				for(DESIt->first(); DESIt->isDone() == false; DESIt->next())
				{
					const Des& currentDes = DESIt->currentItem();
					if (currentDes.findEvent(eventName.toStdWString(),event))
					{
						const DesEvent& newEvent = GTFiDes->addEvent(const_cast<DesEvent&>(*event));
						DesTransition* trans1 = new DesTransition(InState2 , newEvent , InState1);
						GTFiDes->addTransition(const_cast<DesTransition&>(*trans1));
						DesTransition* trans2 = new DesTransition(InState1 , newEvent , InState1);
						GTFiDes->addTransition(const_cast<DesTransition&>(*trans2));
						break;
					}
				}
			}
			ResetFTAlgo::addGTFi(GTFiDes);
			i++;
		}	
	}
	else if (m_faultSets.empty())
		{throw EX("N Fault Events List is empty.");}
}
//____________________________________________________________________________________________________________________________________
void ResetFTAlgo::addGTFi(Des* GTFiDes)
{
	m_flatDummyProject->addPlantDes(GTFiDes); 
}
//____________________________________________________________________________________________________________________________________
bool ResetFTAlgo::verifyFTCtrl()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		MultiCtrlAlgo ctrlAlgo(m_flatDummyProject->createDesIterator(ePlantDes),m_flatDummyProject->createDesIterator(eSupervisorDes));
		m_isResetFaultsControllable = m_flatDummyProject->checkControllable(ctrlAlgo);

		return m_isResetFaultsControllable;
	}
	else
	{throw EX("Project Integrity test has failed");}
	return m_isResetFaultsControllable;
}
//____________________________________________________________________________________________________________________________________
bool ResetFTAlgo::isResetFaultsControllable() const
{
	return m_isResetFaultsControllable;
}
//____________________________________________________________________________________________________________________________________
}


