/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2015
*/

#pragma once
#include "DefaultFTDlg.h"
#include <QMessageBox>
#include <iostream>
namespace DESpot
{

DefaultFTDlg::DefaultFTDlg(DesProject& currentProject, QList<QString>& nonFaultSet, QList<QString>& DFaultSet, QWidget* parent): m_currentProject(currentProject), m_nonFaultSet(nonFaultSet), m_DFaultSet(DFaultSet), QDialog(parent)
{
	setupUi(this);

 

	listProjectEvents();
        modified = true;

	connect(AddFaultsButton, SIGNAL(clicked()), this,SLOT(onAddFaults()));
	connect(RemoveFaultsButton, SIGNAL(clicked()), this,SLOT(onRemoveFaults()));
	connect(ValidateButton, SIGNAL(clicked()), this,SLOT(onValidateFaults()));
}
//_________________________________________________________________________________________________

DefaultFTDlg::~DefaultFTDlg(void)
{
}
//_________________________________________________________________________________________________
void DefaultFTDlg::listProjectEvents()
{

        // RJL: modified to make sure events still belong to project, and to make
        // list of non-fault events is uptodate

	DesProject::EventIteratorPtr eventIt = 
              m_currentProject.createProjEventIterator();
	if (! m_DFaultSet.isEmpty())
	{
           for(int i=0 ; i < m_DFaultSet.size(); i++)
	   {	
              // verify that excluded fault is still a valid project event
              QString fltEventName = m_DFaultSet.at(i);
              bool eventFound = false;

       	      for(eventIt->first(); eventIt->isDone() == false; eventIt->next())
	      {
	          const DesEvent& event = eventIt->currentItem();
		  QString eventName = QString::fromStdWString(event.getName());
		  if (eventName == fltEventName){
		     eventFound = true;
                     break;
		  }
	      }

	      if (eventFound) {
                 //  event is a valid project event
                 new QListWidgetItem(m_DFaultSet.at(i),FualtsEventsQListWidget);
	      }
	    }	 	
        } 	


	//  set non-fault list to all events in project
	m_nonFaultSet.clear();

	for(eventIt->first(); eventIt->isDone() == false; eventIt->next())
	{
		const DesEvent& event = eventIt->currentItem();

		QString eventName = QString::fromStdWString(event.getName());
		m_nonFaultSet.append(eventName);
	}


	if (! m_nonFaultSet.isEmpty())
	{	
	  for(int i=0 ; i < m_nonFaultSet.size(); i++)
	  {
             QString fltEventName = m_nonFaultSet.at(i);

	     if (! m_DFaultSet.contains(fltEventName))  {
		new QListWidgetItem(m_nonFaultSet.at(i),ProjectEventsQListWidget);
             }

          }
	}

}
//_________________________________________________________________________________________________
void DefaultFTDlg::onAddFaults()
{
	QListWidgetItem *item = ProjectEventsQListWidget->currentItem();
	if (item)
	{
		ProjectEventsQListWidget->takeItem(ProjectEventsQListWidget->currentRow());
		FualtsEventsQListWidget->addItem(item);
	}
	ProjectEventsQListWidget->update();
	FualtsEventsQListWidget->update();
	valid = false;
	modified = true;
}
//_________________________________________________________________________________________________
void DefaultFTDlg::onRemoveFaults()
{
	QListWidgetItem *item = FualtsEventsQListWidget->currentItem();
	if (item)
	{
		FualtsEventsQListWidget->takeItem(FualtsEventsQListWidget->currentRow());
		ProjectEventsQListWidget->addItem(item);
	}
	ProjectEventsQListWidget->update();
	FualtsEventsQListWidget->update();
	modified = true;
}
//_________________________________________________________________________________________________
bool DefaultFTDlg::onValidateFaults()
{
	if (! valid)
	{	
		for(int i=0; i< FualtsEventsQListWidget->count(); i++)
		{
			QString eventName = FualtsEventsQListWidget->item(i)->text();

			DesProject::EventIteratorPtr eventIt =  m_currentProject.createProjEventIterator();
			for(eventIt->first(); eventIt->isDone() == false; eventIt->next())
			{
				const DesEvent& event = eventIt->currentItem();
				QString currentEventName = QString::fromStdWString(event.getName());
				if (currentEventName == eventName)
				{
					if (event.isControllable())
					{
						QMessageBox msgBox;
						msgBox.setText("Fault events should not be a controllable event");
						msgBox.setIcon(QMessageBox::Critical);
						msgBox.exec();
						return valid;
					}
				}
			}

			const DesEvent* event;
			DesProject::DesIteratorPtr supIt = m_currentProject.createDesIterator(eSupervisorDes);
			for(supIt->first(); supIt->isDone() == false; supIt->next())
			{
				const Des& supDes = supIt->currentItem();
				if (supDes.findEvent(eventName.toStdWString(),event))
				{QMessageBox msgBox;
				msgBox.setText("Fault events should not belong to a supervisor");
				msgBox.setIcon(QMessageBox::Critical);
				msgBox.exec();
				return valid;}
			}
		}
	}
QMessageBox msgBox;
msgBox.setText("Fault events are valid");
msgBox.setIcon(QMessageBox::Information);
msgBox.exec();
valid = true;
return valid;	
}
//_________________________________________________________________________________________________
void DefaultFTDlg::accept()
{

	if (DefaultFTDlg::onValidateFaults())
	{	
		if (modified)
		{
			m_nonFaultSet.clear();
			for(int i=0; i< ProjectEventsQListWidget->count(); i++)
			{
				QString eventName = ProjectEventsQListWidget->item(i)->text();
				m_nonFaultSet.append(eventName);
			}
			m_currentProject.setNonFaultSet(m_nonFaultSet);

			m_DFaultSet.clear();
			for(int i=0; i< FualtsEventsQListWidget->count(); i++)
			{
				QString eventName = FualtsEventsQListWidget->item(i)->text();
				m_DFaultSet.append(eventName);
			}
			m_currentProject.setDFaultSet(m_DFaultSet);
		}
	m_currentProject.setExcldEvntsValid(true);
	m_currentProject.setFaultSetsValid(false);
	QDialog::accept();
	}

}
} // end of namespace DESpot
