/*************************************************************************
 * This file is part of Graphic des EDitor project    
 *
 * Project created in conformity with the requirements for the Degree of
 * Master of Engineering in Software Engineering, Computing and Software
 * Department, McMaster University 2004 - 2008
 *
 * Author:	Xiao Ma
 * Supervisor: Dr. Ryan Leduc
*************************************************************************/

/* 
 NAME
   GedDesTransEditor.h - Ged DES transition function editor. 
 FUNCTION
   The class provides a dialog to modify the properties of a graphic transition
   function by adding or removing events to the transition. A graphic transition
   function may represent multiple DES transition function. 
 NOTES
 MODIFIED
   xma	    04/01/08 - CREATION 
*/

#ifndef GEDDESTRANSEDITOR_H
#define GEDDESTRANSEDITOR_H

#include <QDialog>
#include <QMap>

class QListWidget;
class QPushButton;

namespace DESpot
{

class Des;
class DesEvent;
class GedDesTrans;

class GedDesTransEditor : public QDialog
{
    Q_OBJECT

public:
    GedDesTransEditor(Des* des, GedDesTrans *gedTrans, QWidget *parent = 0);
    void done(int result);
	bool isSelectedEventsEmpty()
	{return selectedEvents.isEmpty();}

private slots:
	void add();
	void remove();

private:
	void createAvailEventList();
	void createSelectedEventList();


    QListWidget *availEventListWidget;
    QListWidget *selectedEventListWidget;
    QPushButton *addButton;
    QPushButton *removeButton;
    QPushButton *okButton;
    QPushButton *cancelButton;
	Des* des;
	GedDesTrans* gedTrans;
	bool modified;
	QList<const DesEvent* > selectedEvents;

};

}
#endif


