/*************************************************************************
 * This file is part of the Distributed Computation feature
 *
 * Project created in conformity with the requirements for the Degree of
 * Master of Engineering in Software Engineering, Computing and Software
 * Department, McMaster University 2012
 *
 * Author:	David Kirby
 * Supervisor: Dr. Ryan Leduc
 *
 * Description: Static class that manages interactions with the HostFile.
 * Not thread safe, but it shouldn't ever need to be accessed by more than
 * one thread anyways.
 ************************************************************************/
#pragma once

#include <string>
#include <vector>
#include <iostream>
#include <fstream>
#include <sstream>

#include "CommonDefinitions.h"

#include <sys/stat.h>

using namespace std;
namespace DESpot
{
	class HostFileManager
	{
		public:
			static bool hostFileExists();
						
			static void createHostFile();
			static void loadHostFile();
			static void saveHostFile(string nodes);

			static void first();
			static void next();
			static string getCurrent();
			static bool done();
			static int length();	

			static string getHostFileName();

		private:
			static string hostfile;
			static vector<string> m_nodes;
			static int m_ctr;
	};
}
