/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <string>
#include <QString>

class QTextStream;

namespace DESpot
{
	class DesProject;
	class DesHierProject;
	class DesSubsystem;
	class DesInterface;
	class Des;

	class SimConfigPrinter
	{
		public:
			SimConfigPrinter(const DesProject& project);
			~SimConfigPrinter(void);

		public:
			void print(const std::wstring& fileName);

		private:
			void printProject(QTextStream& out);
			void printHeader(QTextStream& out);
			
			void printFlatSupervisor(QTextStream& out);
			void printFlatPlant(QTextStream& out);

			void printHighLevelSubsys(QTextStream& out);
			void printLowLevelSubsys(QTextStream& out);
			void printSubsystem(QTextStream& out, const DesSubsystem& subsys);
			void printInterfaces(QTextStream& out);
			void printInterface(QTextStream& out, const DesInterface& interf);

			void printDes(QTextStream& out, const Des& des);

		private:
			bool isHierProject();
			const DesHierProject& hierProject();

			QString	getProjectType();
			QString getProjIntegrity();
			QString	getCtrlProp();
			QString	getNonBlockProp();
			QString getLwCtrlProp();
			QString getLwCtrlProp(const DesSubsystem& subsys);
			QString getLwNonBlockProp();
			QString getLwNonBlockProp(const DesSubsystem& subsys);
			QString getIConsistProp();
			QString getIConsistProp(const DesSubsystem& subsys);
			QString toString(int intVal);
			QString toString(const std::wstring& stdStr);

		private:
			const DesProject& m_project;

		private:
			static const QString cFileHeader;
			static const QString cSupervisorHeader;
			static const QString cPlantHeader;
			static const QString cSubsysHeader;
			static const QString cInterfaceHeader;

			static const QString cProjNameLabel;

			static const QString cProjTypeLabel;
			static const QString cProjTypeFlatVal;
			static const QString cProjTypeHierVal;

			static const QString cProjFileNameLabel;
			static const QString cProjFileVersionLabel;
			static const QString cProjFileVersion;

			static const QString cProjIntegLabel;
			static const QString cProjIntegDateLabel;
			static const QString cProjIntegDatePrefix;
			static const QString cProjIntegStatusYesVal;
			static const QString cProjIntegStatusNoVal;
			static const QString cProjIntegStatusNotVerifVal;

			static const QString cProjPropLabel;
			static const QString cProjCtrlLabel;
			static const QString cProjCtrlDateLabel;
			static const QString cProjCtrlPropYesVal;
			static const QString cProjCtrlPropNoVal;
			static const QString cProjCtrlPropNotVerifVal;

			static const QString cProjNonblockLabel;
			static const QString cProjNonBlockDateLabel;
			static const QString cProjNonBlockPropYesVal;
			static const QString cProjNonBlockPropNoVal;
			static const QString cProjNonBlockPropNotVerifVal;

			static const QString cLwCtrlLabel;
			static const QString cLwCtrlDateLabel;
			static const QString cLwCtrlPropYesVal;
			static const QString cLwCtrlPropNoVal;
			static const QString cLwCtrlPropNotVerifVal;

			static const QString cLwNonBlockLabel;
			static const QString cLwNonBlockDateLabel;
			static const QString cLwNonBlockPropYesVal;
			static const QString cLwNonBlockPropNoVal;
			static const QString cLwNonBlockPropNotVerifVal;

			static const QString cIConsistLabel;
			static const QString cIConsistDateLabel;
			static const QString cIConsistPropYesVal;
			static const QString cIConsistPropNoVal;
			static const QString cIConsistPropNotVerifVal;

			static const QString cDesNameLabel;
			static const QString cDesFileNameLabel;

			static const QString cSubsysNameLabel;
			static const QString cSubsysDegreeLabel;
			static const QString cSubsysPropLabel;
			static const QString cSubsysIConsistLabel;
			static const QString cSubsysLwNonBlockLabel;
			static const QString cSubsysLwCtrlLabel;
			static const QString cSubsysImplLabel;
			static const QString cSubsysUsesLabel;
			static const QString cSubsysSupervisorLabel;
			static const QString cSubsysPlantLabel;
			static const QString cInterfUsePrefix;
			static const QString cNoInterf;
			static const QString cSubsysSpacePrefix;

			static const QString cInterfSpacePrefix; 
			static const QString cInterfNameLabel;
			static const QString cInterfDesComp;

	};
}
