#ifndef SimStateParser_H
#define SimStateParser_H

#include "SimStateNode.h"
#include "DesHierProject.h"
#include "DesFlatProject.h"
#include "DesProject.h"
#include "SimCompState.h"
#include "SimWorkspace.h"

namespace DESpot
{

class SimStateParser
{
public:
	enum ParseType {Hier, Flat};
	SimStateParser(const DesProject *proj, const SimWorkspace::SimGedViewerMap* pSimGedViewers = 0);
    Node *parse(ParseType type);
	Node *parse(SimCompState::StateTuple *globalSta, ParseType type);

private:
	Node *parseAsFlat();
	Node *parseFlat();
    Node *parseHierProject();
    Node *parseProejctMetaData();
	Node *parseHighLevel();
    Node *parseInterface();
    Node *parseLowLevel();
	bool isStateTupleInit();
	bool isStateTupleMarked();
    void addChild(Node *parent, Node *child);
	void addDesNodes(Node *parent, DesProject::DesIteratorPtr& desIt);
	DesHierProject* project();

    QString in;
    int pos;

	const DesProject*   m_pProject;
    ProjectType	projectType;
	DesHierProject*		hierProject;
	DesFlatProject*		flatProject;
	ParseType			type;
	SimCompState::StateTuple* globalState;
	const SimWorkspace::SimGedViewerMap*  m_pSimGedViewers;
};
}
#endif
