#include "SyncAlgo.h"


#include "Des.h"

namespace DESpot
{


const std::wstring SyncAlgo::cSyncDesc = L"Sync Algorithm";

//_________________________________________________________________________________________________

SyncAlgo::SyncAlgo(bool checkIntegrity/* = true*/) : MeetAlgo(checkIntegrity)
{
	m_description = cSyncDesc;
}

//_________________________________________________________________________________________________

SyncAlgo::SyncAlgo(const Des* des1, const Des* des2, bool checkIntegrity /*= true*/) : MeetAlgo(des1, des2, checkIntegrity)
{
	m_description = cSyncDesc;
}

//_________________________________________________________________________________________________

SyncAlgo::SyncAlgo(DesProject::DesIteratorPtr desIterator, bool checkIntegrity /*= true*/) : MeetAlgo(desIterator, checkIntegrity)
{
	m_description = cSyncDesc;
}

//_________________________________________________________________________________________________

SyncAlgo::~SyncAlgo(void)
{
}
//_________________________________________________________________________________________________



void SyncAlgo::loadProductDes()
{
		createOutputDes();
		//load ProductTransitionMap
		tranMap= new ProductTransitionMap(m_inDesSet,m_outDes);
        DesNum=tranMap->getDesNum();
		EventNum=tranMap->getEventNum();
        StateMaxNum=tranMap->getStateMaxNum();
        transitionMatrix=tranMap->getTransitionMatrix();

       //load turpleStorage
		turpleStorage=new MeetSynTrie(m_inDesSet);
		main_pendinglist=new PendingList(DesNum);
}


std::wstring SyncAlgo::composeOutputDesName()
{
	std::wstring outputDesName = m_inDesSet[0]->getName();;
	for(unsigned int iDes = 1; iDes < m_inDesSet.size(); ++iDes)
	{
		outputDesName += L"_-_";

		outputDesName += m_inDesSet[iDes]->getName();
	}

	return outputDesName;
}

bool SyncAlgo::runAlgo()
{
	return MeetAlgo::runAlgo();
}









}












