/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QDialog>
#include "ui_CheckProjectDlg.h"
#include "DesProject.h"

namespace DESpot
{
	class CheckProjectDlg: public QDialog, private Ui::CheckProjectDialogUI
	{
	 	Q_OBJECT

		public:
			CheckProjectDlg(ProjectType projType, QWidget* parent /*= null*/);
			virtual ~CheckProjectDlg(void);

		public:
			bool checkValid();
			bool checkNonBlocking();
			bool checkCtrl();
			bool checkIConsist();
			bool checkLwNonBlocking();
			bool checkLwCtrl();

			bool checkIncremental();

		//Overridables
		protected:
			virtual void accept();

		private slots:
			void onSelectAll();
			void onClearAll();

		//Implementation methods
		private:
			//setup the UI according to the project type
			void customizeUi();
			
			//update the UI to show the current values of properties to be checked
			void updateUi();

		private:
			ProjectType m_projType;

			//user's selection of properties to be checked
			bool m_checkValid;
			bool m_checkNonBlock;
			bool m_checkCtrl;
			bool m_checkIConsist;
			bool m_checkLwNonBlock;
			bool m_checkLwCtrl;

			bool m_incCheck;
	};

} //end of namespace DESpot
