/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include "ProjIntegrityAlgo.h"

namespace DESpot
{
	class DesFlatProject;

	class FlatProjIntegrityAlgo: public ProjIntegrityAlgo
	{
		public:
			FlatProjIntegrityAlgo(bool runIncremental = true);
			FlatProjIntegrityAlgo(DesFlatProject* project, bool runIncremental = true);
			virtual ~FlatProjIntegrityAlgo(void);

		//Verification methods: return true if the verification was succesfull and they
		//output warnings and errors in m_warnList and m_errList. Note a verification is
		//successful even if there are warnings
		//protected:
			//Overridable called from the "run" method of the base implementation of the algorithm
			virtual bool verifyIntegrity();

			//verifies that there is at least one supervisor DES in the project
			virtual bool verifySupervisor();

			//verifies that there is at least one plant DES in the project
			virtual bool verifyPlant();

		protected:
			DesFlatProject* flatProject();

		private:
			static const std::wstring cFlatProjIntegAlgoDesc;

			//Warnings

			//Errors
			static const std::wstring cEmptySupervisorErr;
			static const std::wstring cEmptyPlantErr;

	};
}
