/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <string>
#include "MultiCtrlAlgo.h"
#include "DesHierProject.h"

namespace DESpot
{
	class HighSubsysCtrlAlgo : public MultiCtrlAlgo
	{
		public:
			HighSubsysCtrlAlgo(DesHierProject& project);
			virtual ~HighSubsysCtrlAlgo(void);

		public:
			virtual bool runAlgo();

			DesHierProject& getInputProject();

		protected:
			virtual void prepareRun();
			virtual std::wstring prepareErrorDescription();

		protected:
			DesHierProject& m_project;

		private:
			static const std::wstring cHighSubsysCtrlAlgoDesc;
			static const std::wstring cHighSubsysCtrlError;
	};
}
