/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2015
*/
#pragma once
#include <iostream>
#include "NFaultsAlgo.h"
#include "Des.h"
#include "DesProject.h"
#include "FlatDummyProject.h"
#include "MultiCtrlAlgo.h"
#include "FlatProjIntegrityAlgo.h"
#include <QMessageBox>

namespace DESpot

{
NFaultsAlgo::NFaultsAlgo(const DesProject& currentProject, QList<QString>& faultSet, int N , QMultiMap<int,QString>& faultSets): DefaultFTAlgo(currentProject, faultSet),m_isNFaultsControllable(false), m_N(N),m_faultSets(faultSets)
{
	GNFDes = NULL;
}
//____________________________________________________________________________________________________________________________________	
NFaultsAlgo::~NFaultsAlgo()
{
}
//____________________________________________________________________________________________________________________________________

bool NFaultsAlgo::runAlgo()
{
	DefaultFTAlgo::createDummyFlatProject();
	if (! m_faultSet.isEmpty())
	{
		DefaultFTAlgo::constructGF();	
		DefaultFTAlgo::addGF();
	}
	int m = m_faultSets.uniqueKeys().size();
	if (m_N < m)
	{
		NFaultsAlgo::constructGNF();
		NFaultsAlgo::addGNF();
	}	
	return NFaultsAlgo::verifyFTCtrl();
}
//____________________________________________________________________________________________________________________________________
void NFaultsAlgo::constructGNF()
{
	if (! m_faultSets.empty())
	{
		
		const std::wstring& name = L"GNF" ;
		GNFDes = new Des(name , eRegularDes);
		
		DesState* InState = new DesState(0);

		InState->setIDasName();
		const DesState& Instate = GNFDes->addState(const_cast<DesState&>(*InState));
		GNFDes->changeStateMarking(Instate.getId(),true);
		GNFDes->changeStateInit(Instate.getId(),true);

		QList<QString> faultEvents = m_faultSets.values();
		for (int i=0 ; i < faultEvents.size() ; i++)
		{ 
			QString eventName = faultEvents.at(i);
			const DesEvent* event;
			DesProject::DesIteratorPtr DESIt = m_currentProject.createDesIterator();
			for(DESIt->first(); DESIt->isDone() == false; DESIt->next())
			{
				const Des& currentDes = DESIt->currentItem();
				if (currentDes.findEvent(eventName.toStdWString(),event))
				{
					GNFDes->addEvent(const_cast<DesEvent&>(*event));
					break;
				}
			}
		}
	
		for (int j=1 ; j <= m_N ; j++)
		{
			const DesState& preState = GNFDes->getState(GNFDes->getLastUsedStateId());
			DesState* newState = new DesState(j+1);
			newState->setIDasName();
			const DesState& state = GNFDes->addState(const_cast<DesState&>(*newState));
			GNFDes->changeStateMarking(state.getId(),true);
			Des::EventIteratorPtr eventIt = GNFDes->createEventIterator();
			for(eventIt->first(); eventIt->isDone() == false; eventIt->next())
			{
				const DesEvent& event = eventIt->currentItem();
				DesTransition* trans = new DesTransition(preState , event , state);
				GNFDes->addTransition(const_cast<DesTransition&>(*trans));
			}		
		}
	}

}
//____________________________________________________________________________________________________________________________________
void NFaultsAlgo::addGNF()
{
	m_flatDummyProject->addPlantDes(GNFDes); 
}
//____________________________________________________________________________________________________________________________________
bool NFaultsAlgo::verifyFTCtrl()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		MultiCtrlAlgo ctrlAlgo(m_flatDummyProject->createDesIterator(ePlantDes),m_flatDummyProject->createDesIterator(eSupervisorDes));
		m_isNFaultsControllable = (m_flatDummyProject->checkControllable(ctrlAlgo));

		return m_isNFaultsControllable;
	}
	else
	{throw EX("Project Integrity test has failed");}
	return m_isNFaultsControllable;
}
//____________________________________________________________________________________________________________________________________
bool NFaultsAlgo::isNFaultsControllable() const
{
	return m_isNFaultsControllable;
}
//____________________________________________________________________________________________________________________________________
}


