/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2015
*/

#include <iostream>
#include "ResetFTAlgoNonBlock.h"
#include "MultiNonBlockingAlgo.h"
#include "FlatProjIntegrityAlgo.h"

namespace DESpot
{
ResetFTAlgoNonBlock::ResetFTAlgoNonBlock(const DesProject& currentProject, QList<QString>& faultSet ,int M , QMultiMap<int, QString>& faultSets, QMultiMap<int, QString>& resetSets): ResetFTAlgo(currentProject, faultSet, M , faultSets, resetSets)
{
	m_isResetFaultsNonblocking = false;
}
//____________________________________________________________________________________________________________________________________	
ResetFTAlgoNonBlock::~ResetFTAlgoNonBlock()
{
}
//____________________________________________________________________________________________________________________________________
bool ResetFTAlgoNonBlock::runAlgo()
{
	DefaultFTAlgo::createDummyFlatProject();
	if (! m_faultSet.isEmpty())
	{
		DefaultFTAlgo::constructGF();
		DefaultFTAlgo::addGF();
	}
	ResetFTAlgo::constructGTFi();
	return ResetFTAlgoNonBlock::verifyFTNonBlock();
}
//____________________________________________________________________________________________________________________________________
bool ResetFTAlgoNonBlock::verifyFTNonBlock()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		MultiNonBlockingAlgo flatNonBlock;
		DesSubsystem::DesIteratorPtr hDesIt = m_flatDummyProject->createDesIterator();
		for(hDesIt->first(); hDesIt->notDone(); hDesIt->next())
		{
			const Des& hDes = hDesIt->currentItem();
			flatNonBlock.addInputDes(&hDes);
		}
		m_isResetFaultsNonblocking = m_flatDummyProject->checkNonBlocking(flatNonBlock);

		return m_isResetFaultsNonblocking;
	}
	else
	{throw EX("Project Integrity test has failed");}
	return m_isResetFaultsNonblocking;
}
//____________________________________________________________________________________________________________________________________
bool ResetFTAlgoNonBlock::isResetFaultsNonblocking() const
{
	return m_isResetFaultsNonblocking;
}
//____________________________________________________________________________________________________________________________________
}

