/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2016
*/

#pragma once
//#include <iostream>
#include "BDDDefaultFTAlgoNonblocking.h"
#include "Des.h"
#include "DesFlatProject.h"
#include "FlatDummyProject.h"
#include "MultiCtrlAlgo.h"
#include "FlatProjIntegrityAlgo.h"
#include "BddSdMain.h"

namespace DESpot
{
BDDDefaultFTAlgoNonblocking::BDDDefaultFTAlgoNonblocking(const DesProject& currentProject, QList<QString>& currentFaultSet): DefaultFTAlgo(currentProject, currentFaultSet),m_isBDDDFTNonblocking(false)
{
	GFDes = NULL;
	m_flatDummyProject = NULL;
}
//____________________________________________________________________________________________________________________________________	
BDDDefaultFTAlgoNonblocking::~BDDDefaultFTAlgoNonblocking()
{
}
//____________________________________________________________________________________________________________________________________
BDDSD::SD_NBChkInfo BDDDefaultFTAlgoNonblocking::runBDDFTNonblockingAlgo()
{

	// check that excluded fault set is valid
	if (! (m_currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  

	if (! m_faultSet.isEmpty())	
	{
		DefaultFTAlgo::createDummyFlatProject();
		DefaultFTAlgo::constructGF();
		DefaultFTAlgo::addGF();
		return BDDDefaultFTAlgoNonblocking::verifyBDDFTNonblocking();
	}
	else
	{throw EX("There are no excluded fault events. Please run the standard nonblocking algorithm.");}
}
//____________________________________________________________________________________________________________________________________
BDDSD::SD_NBChkInfo BDDDefaultFTAlgoNonblocking::verifyBDDFTNonblocking()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		int tmp;
		BDDSD::SD_NBChkInfo  checkInfo("Project passes Nonblocking Check");
		tmp = BddSdCheckNB((DesProject&) *m_flatDummyProject, checkInfo);

     		if (checkInfo.m_chkPassed)
			m_isBDDDFTNonblocking = true;
		else
			m_isBDDDFTNonblocking = false;

		return checkInfo;
	}
	else
	{throw EX("Project Integrity test has failed");}
}
//____________________________________________________________________________________________________________________________________
bool BDDDefaultFTAlgoNonblocking::isBDDDFTNonblocking() const
{
	return m_isBDDDFTNonblocking;
}
//____________________________________________________________________________________________________________________________________
}


