/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2016
*/
#pragma once
#include <iostream>
#include "BDDResetFTAlgoNonblocking.h"
#include "Des.h"
#include "DesProject.h"
#include "FlatDummyProject.h"
#include "FlatProjIntegrityAlgo.h"
#include "BddSdMain.h"


namespace DESpot
{
BDDResetFTAlgoNonblocking::BDDResetFTAlgoNonblocking(const DesProject& currentProject, QList<QString>& faultSet ,int M , QMultiMap<int, QString>& faultSets, QMultiMap<int, QString>& resetSets) : ResetFTAlgo(currentProject, faultSet, M , faultSets, resetSets), m_BDDResetFaultsNonblocking(false)
{
}
//____________________________________________________________________________________________________________________________________	
BDDResetFTAlgoNonblocking::~BDDResetFTAlgoNonblocking()
{
}
//____________________________________________________________________________________________________________________________________
BDDSD::SD_NBChkInfo BDDResetFTAlgoNonblocking::runBDDFTNonblockingAlgo()
{
	DefaultFTAlgo::createDummyFlatProject();
	if (! m_faultSet.isEmpty())
	{
		DefaultFTAlgo::constructGF();
		DefaultFTAlgo::addGF();
	}
	ResetFTAlgo::constructGTFi();
	return BDDResetFTAlgoNonblocking::verifyBDDFTNonblocking();
}
//____________________________________________________________________________________________________________________________________
BDDSD::SD_NBChkInfo BDDResetFTAlgoNonblocking::verifyBDDFTNonblocking()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		int tmp;
		BDDSD::SD_NBChkInfo  checkInfo("Project passes Nonblocking Check");
      		tmp =  BddSdCheckNB((DesProject&) *m_flatDummyProject, checkInfo);

     		if (checkInfo.m_chkPassed)
			m_BDDResetFaultsNonblocking = true;
		else
			m_BDDResetFaultsNonblocking = false;

		return checkInfo;
	}
	else
	{throw EX("Project Integrity test has failed");}

}
//____________________________________________________________________________________________________________________________________
bool BDDResetFTAlgoNonblocking::isBDDResetFaultsNonblocking() const
{return m_BDDResetFaultsNonblocking;}
}


