/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include <QHeaderView>
#include <QResizeEvent>

#include "DesDataTableWidget.h"
#include "Des.h"


namespace DESpot
{

const QString DesDataTableWidget::cYes = "Yes";
const QString DesDataTableWidget::cNo = "No";
const QString DesDataTableWidget::cUnknown = "Unknown";

DesDataTableWidget::DesDataTableWidget(QWidget* parent) : QTableWidget(parent)
{
}

//_________________________________________________________________________________________________

DesDataTableWidget::~DesDataTableWidget(void)
{
}

//_________________________________________________________________________________________________

void DesDataTableWidget::setupWidget(int colCount)
{
	m_tableColCount = colCount;
	
	clearContents();
	setColumnCount(m_tableColCount);
	verticalHeader()->hide();
	horizontalHeader()->hide();
	horizontalHeader()->setStretchLastSection(true);
	setGridStyle(Qt::NoPen);
}

//_________________________________________________________________________________________________

int DesDataTableWidget::calculateRowCount(const int itemCount, const int colCount)
{
	int rowCount = itemCount / colCount;
	if (itemCount % colCount > 0)
	{
		rowCount++; //increase the row count for the remainder of states
	}

	return rowCount;
}

//_________________________________________________________________________________________________

void DesDataTableWidget::calculateNextRowAndCol(int& io_row, int& io_col)
{
	if (io_col < m_tableColCount - 1)
	{
		io_col++; //there are still columns left in this row
	}
	else
	{
		//the current row has been filled. go to the next row
		io_col = 0;
		io_row++;
	}
}

//_________________________________________________________________________________________________

void DesDataTableWidget::autoResizeTableRows()
{
	QHeaderView* vHeader = verticalHeader();
	for(int iRow = 0; iRow < rowCount(); iRow++)
	{
		vHeader->resizeSection(iRow, vHeader->sectionSizeHint(iRow));		
	}
}

//_________________________________________________________________________________________________

void DesDataTableWidget::resizeEvent(QResizeEvent* event)
{
	QTableWidget::resizeEvent(event);
	
	const int tableWidth = event->size().width();
	const int defColumnWidth = tableWidth / columnCount();
	int totalSizeSoFar = 0;
	for(int iCol = 0; iCol < columnCount() - 1; iCol++)
	{
		horizontalHeader()->resizeSection(iCol, defColumnWidth);

		totalSizeSoFar += defColumnWidth;
	}
	horizontalHeader()->viewport()->resize(tableWidth, horizontalHeader()->viewport()->geometry().height());
	horizontalHeader()->resizeSection(columnCount() - 1, tableWidth - totalSizeSoFar);
}

} //end of namespace DESpot
