/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QTreeWidget>

namespace DESpot
{
	class DespotTreeWidget : public QTreeWidget
	{
		Q_OBJECT
		
		public:
			DespotTreeWidget(QWidget* parent = 0);
			virtual ~DespotTreeWidget(void);

		public:
			void setBoxWidget(QWidget* pBoxWidget);
			QWidget* getBoxWidget();

			void setCircularCursor(bool bCircularCursor = true);

			void setShareFocus(bool shareFocus = true);

			void setContextMenu(QMenu& contextMenu);

			QTreeWidgetItem* getNextSibling(QTreeWidgetItem* item);

		public slots:
			void onSortByColumn(int column);
			void updateSortIndicators(int oldCount, int newCount);

		signals:
			void onWidthChanged(int newWidgetWidth);
			void onCurrentItemDeleted();
			void onActiveItemChanged(QTreeWidgetItem* current, QTreeWidgetItem* previous);

		
		protected:
			virtual QModelIndex moveCursor(CursorAction cursorAction, Qt::KeyboardModifiers modifiers);
			virtual void keyPressEvent(QKeyEvent * keyEvent);
			virtual void resizeEvent(QResizeEvent* event);
			virtual void focusInEvent(QFocusEvent* event);
			virtual void focusOutEvent(QFocusEvent* event);
			virtual void contextMenuEvent(QContextMenuEvent* event);
			virtual bool eventFilter(QObject* target, QEvent* event);

		private:
			QWidget* m_pBoxWidget;
			QTreeWidgetItem* m_pCrtItem;

			QMenu* m_pContextMenu;
			
			//true while the context menu for this UI part is displayed and false otherwise
			bool m_ctxMenuDisplayed;

			bool m_bCircularCursor;

			//true if multiple DespotTreeWidget share the focus in a form and thus only one of them
			//has to show it. In this case when the widget looses focus the current item is deselected
			bool m_sharedFocus;

			//holds the sorting indicators for the columns
			std::vector<bool> m_sortIndicators;

	};

} //end of namespace DESpot
