/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include "ProjectWorkspace.h"
#include "ui_FlatProjectEditor.h"

class QResizeEvent;
class QButtonGroup;

namespace DESpot
{

class FlatProjectEditor;
class DesFlatProject;
class FlatProjStructureUiPart;
class FlatProjSummaryUiPart;


class FlatProjectWorkspace: public ProjectWorkspace, private Ui::FlatProjectEditorUI
{
	Q_OBJECT

	public:
		FlatProjectWorkspace(FlatProjectEditor* pFlatProjectEditor, DesFlatProject* pProject);
		virtual ~FlatProjectWorkspace(void);

	public:
		virtual ProgressWidget* progressWidget();

	//Overridables_________________________________________________
	protected:
		virtual bool eventFilter(QObject* target, QEvent* event);

	//Implementations Methods _____________________________________
	private:
		FlatProjectEditor* flatProjectEditor();
		
		void createUiParts(DesFlatProject* pProject);
		void setupEventFilters();
		//setup connections between widgets
		void setupConnections();
		
		//Added by Adam for BDDExport
		void createActions();
		void setupMenu();
		//Added by Amal for FTDES
		void setupToolBar();

		void positionSplitters();

	//UI Parts specific to flat projects (the rest are inherited from the ProjectWorkspace
	private:
		FlatProjStructureUiPart* m_pStructureUiPart;
	//Menus_______________________________________________
		QMenu* m_FTCtrlMenu;
		QMenu* m_TimedFTCtrlMenu;
		QMenu* m_FTNonBlockMenu;

		QMenu* m_BDDFTCtrlMenu;
		QMenu* m_TimedBDDFTCtrlMenu;
		QMenu* m_BDDFTNonBlockMenu;

	//Actions_____________________________________________________
	private:
		//Added by Adam for BDDExport
		QAction* m_exportToBDDsdAct;
		//Added By Amal for Timed DES cont.
		QAction* m_runTimedCtrlToolAct;
		//Added By Amal for FT cont.
		QAction* m_runFTCtrlToolAct1;
		QAction* m_runFTCtrlToolAct2;
		QAction* m_runFTCtrlToolAct3;
		QAction* m_runFTCtrlToolAct4;
		//Added By Amal for Timed FT DES cont.
		QAction* m_runTimedFTCtrlToolAct1;
		QAction* m_runTimedFTCtrlToolAct2;
		QAction* m_runTimedFTCtrlToolAct3;
		QAction* m_runTimedFTCtrlToolAct4;
		//Added By Amal for FT nonBlocking
		QAction* m_runFTNonBlockToolAct1;
		QAction* m_runFTNonBlockToolAct2;
		QAction* m_runFTNonBlockToolAct3;
		QAction* m_runFTNonBlockToolAct4;
		QAction* m_saveFaultsToolAct;
		QAction* m_saveFaultsReseatableToolAct;

		//Added by Adam for BDD Tools
                #ifdef __ENABLE_BDD__
		QAction* m_runBddCheckAllToolAct;
		QAction* m_runBddNonblockingToolAct;
		QAction* m_runBddControllabilityToolAct;
		QAction* m_runBddNBControllabilityToolAct;
		QAction* m_runBddTDESControllabilityToolAct;
		QAction* m_runBddSDControllabilityToolAct;
		QAction* m_runBddProperTimebehaviorToolAct;
		QAction* m_runBddSSingularProhibitableBehaviorToolAct;
		QAction* m_runBddPlantCompletenessToolAct;
		QAction* m_runBddALFToolAct;
		//Added by Amal for FT
		QAction* m_onRunBDDDFTCtrlAct;
		QAction* m_onRunTimedBDDDFTCtrlAct;
		QAction* m_onRunBDDNFFTCtrlAct;
		QAction* m_onRunTimedBDDNFFTCtrlAct;
		QAction* m_onRunBDDNonRepFTCtrlAct;
		QAction* m_onRunTimedBDDNonRepFTCtrlAct;
		QAction* m_onRunBDDResettableFTCtrlAct;
		QAction* m_onRunTimedBDDResettableFTCtrlAct;
		QAction* m_onRunBDDDFTNonBlockAct;
		QAction* m_onRunBDDNFFTNonBlockAct;
		QAction* m_onRunBDDNonRepFTNonBlockAct;
		QAction* m_onRunBDDResettableFTNonBlockAct;
                #endif

		//Added by David for Distributed Tools		
		QAction* m_runDistCheckAll;
};

} //end of namespace DESpot
