/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <list>
#include <map>
#include "DesAlgo.h"

namespace DESpot
{
	class IntegrityAlgo : public DesAlgo
	{
		public:
			IntegrityAlgo(void);
			virtual ~IntegrityAlgo(void);

		public:
			//Runs the algorithm and returns true if DES is consistent
			virtual bool runAlgo();

			//Returns true if the structure we're checking the integrity of is valid
			bool isValid();

			void overrideIsValid();

		//overridables
		//protected:	
			//Prepares the run of the algorithm. Subclasses should call this base version if they override it
			virtual void prepareRun();			

			//This is an abstract class. The subclass will implement this to verify the integrity of whatever
			//data structure they work on
			virtual bool verifyIntegrity() = 0;

		//Implementation methods
		protected:
			typedef std::map<std::wstring, bool> NameMap;
			typedef NameMap::iterator NameIt;
			bool isNameDuplicated(NameMap& nameMap, const std::wstring& name, bool& o_alreadyTested);

		protected:

		protected:
			static const std::wstring cNotCheckedErr;

	};

} //end of namespace DESpot
