/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once
#include <qthread.h>
#include <string>
#include "DesAlgo.h"
#include "DesHierProject.h"
#include "HierProjIntegrityAlgo.h"
#include "CounterExampleAlgo.h"

namespace DESpot
{	
	class HighSubsysCtrlAlgo;
	class LowSubsysCtrlAlgo;

	class LwCtrlAlgo : public DesAlgo, public QThread  
	{
		public:
			LwCtrlAlgo(DesHierProject& project, bool runIncremental = true);
			virtual ~LwCtrlAlgo(void);

		public:
			virtual bool runAlgo();

			virtual bool runAlgo(std::map<std::wstring, bool> &subsysCtrlMap);

			bool runAlgoOnExtractionSystem();

			bool isLwControllable() const;

			void overrideLwControllable(bool lwCtrl);

		protected:
			virtual void prepareRun();

			void clearAlgo();

		
			DesHierProject& m_project;
		//Added by zain for Counter Example
		public:
			DesHierProject& getProject();
		protected:
			HighSubsysCtrlAlgo* m_hCtrlAlgo;
			
			std::vector<LowSubsysCtrlAlgo*> m_lCtrlAlgoList;

			bool m_isLwCtrl;

		private:
			static const std::wstring cLwCtrlAlgoDesc;
			static const std::wstring cIntegrityNotConfirmed;
			static const std::wstring cProjectInvalid;

		public:
            virtual void run();
			bool verifyProjectIntegrity();
	};
}
