/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include "EventViewerWidget.h"
#include "CommonDefinitions.h"
#include "ProjectEvent.h"
#include "SubsystemEvent.h"
#include "InterfaceEvent.h"

namespace DESpot
{
	class DesProject;

	class ProjEventSetWidget: public EventViewerWidget
	{
		public:
			ProjEventSetWidget(QWidget* parent = null);
			~ProjEventSetWidget(void);

		public:
			virtual void initWidget(bool typeHierMode = false);			
			
			void loadEvents(DesProject* project);
			
			QList<const ProjectEvent*> getSelectedEvents();

		protected:
			virtual int getColumnCount();
			virtual void getHeaders(QStringList& out_headerList);

			virtual void fillEventUiItem(QTreeWidgetItem& eventUiItem, const DesEvent& desEvent);
			virtual QString composeTooltip(QTreeWidgetItem& eventUiItem);

			virtual void resizeHeaders(int eventViewWidgWidth);

		private:
			void addRootItems();
			QTreeWidgetItem* createRootItem(const QString& text, QTreeWidgetItem* parent = null);
			QTreeWidgetItem* findRootFor(const ProjectEvent* event);
			QTreeWidgetItem* findRootFor(const InterfaceEvent* interfEvent);
			QTreeWidgetItem* findRootFor(const SubsystemEvent* subsysEvent);

		private:
			bool m_typeHierMode; 

			QTreeWidgetItem* m_typeEventItemList[eLastEventType];
			QTreeWidgetItem* m_interfEventRoot;

		private:
			static const QString cSrcDesColName ;
			static const int  cSrcDesColIdx;

			static const QString cSourceDesTooltip;

			static const QString cHighLevelEventsText;
			static const QString cInterfLevelEventsText;
			static const QString cAnswerEventsText;
			static const QString cRequestLevelEventsText;
			static const QString cLowDataEventsText;
			static const QString cLowLevelEventsText;
	};

} //end of namespace DESpot
